"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EMSTMSSource = void 0;
exports.getSourceTitle = getSourceTitle;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/maps-ems-plugin/common");
var _source = require("../source");
var _util = require("../../../util");
var _update_source_editor = require("./update_source_editor");
var _i18n_getters = require("../../../../common/i18n_getters");
var _constants = require("../../../../common/constants");
var _kibana_services = require("../../../kibana_services");
var _ems_unavailable_message = require("../../../components/ems_unavailable_message");
var _licensed_features = require("../../../licensed_features");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/sources/ems_tms_source/ems_tms_source.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function getErrorInfo(emsTileLayerId) {
  return _i18n.i18n.translate('xpack.maps.source.emsTile.unableToFindTileIdErrorMessage', {
    defaultMessage: `Unable to find EMS tile configuration for id: {id}. {info}`,
    values: {
      id: emsTileLayerId,
      info: (0, _ems_unavailable_message.getEmsUnavailableMessage)()
    }
  });
}
function getSourceTitle() {
  const emsSettings = (0, _kibana_services.getEMSSettings)();
  if (emsSettings.isEMSUrlSet()) {
    return _i18n.i18n.translate('xpack.maps.source.emsOnPremTileTitle', {
      defaultMessage: 'Elastic Maps Server Basemaps'
    });
  } else {
    return _i18n.i18n.translate('xpack.maps.source.emsTileTitle', {
      defaultMessage: 'EMS Basemaps'
    });
  }
}
class EMSTMSSource extends _source.AbstractSource {
  static createDescriptor(descriptor) {
    return {
      type: _constants.SOURCE_TYPES.EMS_TMS,
      id: descriptor.id,
      isAutoSelect: typeof descriptor.isAutoSelect !== 'undefined' ? descriptor.isAutoSelect : false,
      lightModeDefault: descriptor.lightModeDefault === undefined || descriptor.lightModeDefault !== _common.DEFAULT_EMS_ROADMAP_ID ? (0, _kibana_services.getEmsTileLayerId)().desaturated : _common.DEFAULT_EMS_ROADMAP_ID
    };
  }
  constructor(descriptor) {
    const emsTmsDescriptor = EMSTMSSource.createDescriptor(descriptor);
    super(emsTmsDescriptor);
    (0, _defineProperty2.default)(this, "_descriptor", void 0);
    this._descriptor = emsTmsDescriptor;
  }
  renderSourceSettingsEditor({
    onChange
  }) {
    return /*#__PURE__*/_react.default.createElement(_update_source_editor.UpdateSourceEditor, {
      onChange: onChange,
      config: this._descriptor,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 12
      }
    });
  }
  async getImmutableProperties() {
    const tileServiceName = await this._getTileServiceName();
    const autoSelectMsg = _i18n.i18n.translate('xpack.maps.source.emsTile.isAutoSelectLabel', {
      defaultMessage: 'autoselect based on Kibana theme'
    });
    const props = [{
      label: (0, _i18n_getters.getDataSourceLabel)(),
      value: getSourceTitle()
    }, {
      label: _i18n.i18n.translate('xpack.maps.source.emsTile.serviceId', {
        defaultMessage: `Tile service`
      }),
      value: this._descriptor.isAutoSelect ? `${tileServiceName} - ${autoSelectMsg}` : tileServiceName
    }];
    const emsSettings = (0, _kibana_services.getEMSSettings)();
    if (emsSettings.isEMSUrlSet()) {
      props.push({
        label: _i18n.i18n.translate('xpack.maps.source.emsTile.emsOnPremLabel', {
          defaultMessage: `Elastic Maps Server`
        }),
        value: emsSettings.getEMSRoot()
      });
    }
    return props;
  }
  async _getEMSTMSService() {
    let emsTMSServices;
    const emsTileLayerId = this.getTileLayerId();
    try {
      emsTMSServices = await (0, _util.getEmsTmsServices)();
    } catch (e) {
      throw new Error(`${getErrorInfo(emsTileLayerId)} - ${e.message}`);
    }
    const tmsService = emsTMSServices.find(service => service.getId() === emsTileLayerId);
    if (!tmsService) {
      throw new Error(getErrorInfo(emsTileLayerId));
    }
    return tmsService;
  }
  async getDisplayName() {
    return _i18n.i18n.translate('xpack.maps.source.emsTile.basemapLabel', {
      defaultMessage: 'Basemap'
    });
  }
  async _getTileServiceName() {
    try {
      const emsTMSService = await this._getEMSTMSService();
      return emsTMSService.getDisplayName();
    } catch (error) {
      return this.getTileLayerId();
    }
  }
  getAttributionProvider() {
    return async () => {
      const emsTMSService = await this._getEMSTMSService();
      return emsTMSService.getAttributions();
    };
  }
  async getUrlTemplate() {
    const emsTMSService = await this._getEMSTMSService();
    return await emsTMSService.getUrlTemplate();
  }
  getSpriteNamespacePrefix() {
    return 'ems/' + this.getTileLayerId();
  }
  async getVectorStyleSheetAndSpriteMeta(isRetina) {
    const emsTMSService = await this._getEMSTMSService();
    const styleSheet = await emsTMSService.getVectorStyleSheet();
    const spriteMeta = await emsTMSService.getSpriteSheetMeta(isRetina);
    return {
      vectorStyleSheet: styleSheet,
      spriteMeta
    };
  }
  getTileLayerId() {
    if (!this._descriptor.isAutoSelect && this._descriptor.id) {
      return this._descriptor.id;
    }
    return (0, _kibana_services.getIsDarkMode)() ? (0, _kibana_services.getEmsTileLayerId)().dark : this._descriptor.lightModeDefault;
  }
  async getLicensedFeatures() {
    const emsSettings = (0, _kibana_services.getEMSSettings)();
    return emsSettings.isEMSUrlSet() ? [_licensed_features.LICENSED_FEATURES.ON_PREM_EMS] : [];
  }
}
exports.EMSTMSSource = EMSTMSSource;