"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExternalLinkDestinationPicker = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _useMount = _interopRequireDefault(require("react-use/lib/useMount"));
var _useUnmount = _interopRequireDefault(require("react-use/lib/useUnmount"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _external_link_strings = require("./external_link_strings");
var _external_link_tools = require("./external_link_tools");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/private/links/public/components/external_link/external_link_destination_picker.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ExternalLinkDestinationPicker = ({
  onDestinationPicked,
  setDestinationError,
  initialSelection,
  onUnmount,
  ...other
}) => {
  const [validUrl, setValidUrl] = (0, _react.useState)(true);
  const [currentUrl, setCurrentUrl] = (0, _react.useState)(initialSelection !== null && initialSelection !== void 0 ? initialSelection : '');
  (0, _useMount.default)(() => {
    if (initialSelection) {
      const {
        valid,
        message
      } = (0, _external_link_tools.validateUrl)(initialSelection);
      if (!valid) {
        setValidUrl(false);
        setDestinationError(message);
        onDestinationPicked(undefined); // prevent re-saving an invalid link
      } else {
        onDestinationPicked(initialSelection);
      }
    }
  });
  (0, _useUnmount.default)(() => {
    /** Save the current selection so we can re-populate it if we switch back to this link editor */
    onUnmount(currentUrl);
  });

  /* {...other} is needed so all inner elements are treated as part of the form */
  return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({}, other, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    compressed: true,
    value: currentUrl,
    placeholder: _external_link_strings.ExternalLinkStrings.getPlaceholder(),
    isInvalid: !validUrl,
    onChange: event => {
      const url = event.target.value;
      setCurrentUrl(url);
      if (url === '') {
        /* no need to validate the empty string - not an error, but also not a valid destination */
        setValidUrl(true);
        onDestinationPicked(undefined);
        setDestinationError(undefined);
        return;
      }
      const {
        valid,
        message
      } = (0, _external_link_tools.validateUrl)(url);
      setValidUrl(valid);
      if (valid) {
        onDestinationPicked(url);
        setDestinationError(undefined);
      } else {
        onDestinationPicked(undefined);
        setDestinationError(message);
      }
    },
    "data-test-subj": "links--linkEditor--externalLink--input",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 7
    }
  }));
};
exports.ExternalLinkDestinationPicker = ExternalLinkDestinationPicker;