"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.inject = exports.extract = void 0;
var _references = require("../../common/references");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const inject = (state, references) => {
  return {
    ...state,
    ...(0, _references.injectLensReferences)(state, references)
  };
};
exports.inject = inject;
const extract = state => {
  const {
    state: newState,
    references
  } = (0, _references.extractLensReferences)(state);
  return {
    state: {
      ...state,
      ...newState
    },
    references
  };
};
exports.extract = extract;