"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dashboardServicesComparators = void 0;
exports.initializeDashboardServices = initializeDashboardServices;
var _presentationPublishing = require("@kbn/presentation-publishing");
var _presentationContainers = require("@kbn/presentation-containers");
var _rxjs = require("rxjs");
var _helper = require("../helper");
var _type_guards = require("../type_guards");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Convenience type for the serialized props of this initializer

const dashboardServicesComparators = exports.dashboardServicesComparators = {
  ..._presentationPublishing.titleComparators,
  disableTriggers: 'referenceEquality',
  overrides: 'referenceEquality',
  id: 'skip',
  palette: 'skip',
  renderMode: 'skip',
  syncColors: 'skip',
  syncCursor: 'skip',
  syncTooltips: 'skip',
  executionContext: 'skip',
  noPadding: 'skip',
  viewMode: 'skip',
  style: 'skip',
  className: 'skip',
  forceDSL: 'skip',
  esqlVariables: 'skip'
};
/**
 * Everything about panel and library services
 */
function initializeDashboardServices(initialState, getLatestState, internalApi, stateConfig, parentApi, titleManager, {
  attributeService,
  uiActions
}) {
  // For some legacy reason the title and description default value is picked differently
  // ( based on existing FTR tests ).
  const defaultTitle$ = new _rxjs.BehaviorSubject(initialState.attributes.title);
  const defaultDescription$ = new _rxjs.BehaviorSubject(initialState.savedObjectId ? internalApi.attributes$.getValue().description || initialState.description : initialState.description);
  return {
    api: {
      parentApi: (0, _presentationContainers.apiIsPresentationContainer)(parentApi) ? parentApi : undefined,
      defaultTitle$,
      defaultDescription$,
      ...titleManager.api,
      updateOverrides: internalApi.updateOverrides,
      getTriggerCompatibleActions: uiActions.getTriggerCompatibleActions,
      // The functions below fulfill the HasLibraryTransforms interface
      saveToLibrary: async title => {
        const {
          attributes
        } = getLatestState();
        const savedObjectId = await attributeService.saveToLibrary({
          ...attributes,
          title
        }, attributes.references);
        // keep in sync the state
        stateConfig.api.updateSavedObjectId(savedObjectId);
        return savedObjectId;
      },
      checkForDuplicateTitle: async (newTitle, isTitleDuplicateConfirmed, onTitleDuplicate) => {
        await attributeService.checkForDuplicateTitle({
          newTitle,
          isTitleDuplicateConfirmed,
          onTitleDuplicate,
          newCopyOnSave: false,
          newDescription: '',
          displayName: '',
          lastSavedTitle: '',
          copyOnSave: false
        });
      },
      canLinkToLibrary: async () => !getLatestState().savedObjectId && !(0, _helper.isTextBasedLanguage)(getLatestState()),
      canUnlinkFromLibrary: async () => Boolean(getLatestState().savedObjectId),
      getSerializedStateByReference: newId => {
        const currentState = getLatestState();
        return {
          rawState: {
            ...currentState,
            savedObjectId: newId
          }
        };
      },
      getSerializedStateByValue: () => {
        const {
          savedObjectId,
          ...byValueRuntimeState
        } = getLatestState();
        return {
          rawState: (0, _helper.transformToApiConfig)(byValueRuntimeState)
        };
      }
    },
    anyStateChange$: (0, _rxjs.merge)(titleManager.anyStateChange$, internalApi.overrides$, internalApi.disableTriggers$).pipe((0, _rxjs.map)(() => undefined)),
    getLatestState: () => {
      const {
        style,
        className
      } = (0, _type_guards.apiHasLensComponentProps)(parentApi) ? parentApi : {};
      const settings = (0, _presentationContainers.apiPublishesSettings)(parentApi) ? {
        syncColors: parentApi.settings.syncColors$.getValue(),
        syncCursor: parentApi.settings.syncCursor$.getValue(),
        syncTooltips: parentApi.settings.syncTooltips$.getValue()
      } : {};
      return {
        ...titleManager.getLatestState(),
        style,
        className,
        ...settings,
        palette: initialState.palette,
        overrides: internalApi.overrides$.getValue(),
        disableTriggers: internalApi.disableTriggers$.getValue()
      };
    },
    reinitializeState: lastSaved => {
      titleManager.reinitializeState(lastSaved);
      internalApi.updateDisabledTriggers(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.disableTriggers);
      internalApi.updateOverrides(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.overrides);
    }
  };
}