"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cleanupFormulaColumns = cleanupFormulaColumns;
exports.comparePreviousColumnFilter = comparePreviousColumnFilter;
exports.generateMissingFieldMessage = void 0;
exports.getExistsFilter = getExistsFilter;
exports.getFilter = getFilter;
exports.getFormatFromPreviousColumn = getFormatFromPreviousColumn;
exports.getFormulaColumnsFromLayer = getFormulaColumnsFromLayer;
exports.getInvalidFieldMessage = getInvalidFieldMessage;
exports.getSafeName = getSafeName;
exports.hasStateFormulaColumn = hasStateFormulaColumn;
exports.isColumn = void 0;
exports.isColumnFormatted = isColumnFormatted;
exports.isColumnOfType = isColumnOfType;
exports.isMetricCounterField = isMetricCounterField;
exports.isValidNumber = isValidNumber;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _ = require(".");
var _pure_utils = require("../../pure_utils");
var _user_messages_ids = require("../../../../user_messages_ids");
var _layer_helpers = require("../layer_helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/datasources/form_based/operations/definitions/helpers.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function getInvalidFieldMessage(layer, columnId, indexPattern) {
  var _operationDefinition$, _operationDefinition$2;
  if (!indexPattern) {
    return [];
  }
  const column = layer.columns[columnId];
  const {
    operationType
  } = column;
  const operationDefinition = operationType ? _.operationDefinitionMap[operationType] : undefined;
  const fieldNames = (0, _pure_utils.hasField)(column) && operationDefinition ? (_operationDefinition$ = operationDefinition === null || operationDefinition === void 0 ? void 0 : (_operationDefinition$2 = operationDefinition.getCurrentFields) === null || _operationDefinition$2 === void 0 ? void 0 : _operationDefinition$2.call(operationDefinition, column)) !== null && _operationDefinition$ !== void 0 ? _operationDefinition$ : [column.sourceField] : [];
  const fields = fieldNames.map(fieldName => indexPattern.getFieldByName(fieldName));
  const filteredFields = fields.filter(Boolean);
  const isInvalid = Boolean(fields.length > filteredFields.length || !((operationDefinition === null || operationDefinition === void 0 ? void 0 : operationDefinition.input) === 'field' && filteredFields.every(field => operationDefinition.getPossibleOperationForField(field) != null)));
  const isWrongType = Boolean(filteredFields.length && !(operationDefinition !== null && operationDefinition !== void 0 && operationDefinition.isTransferable(column, indexPattern, _.operationDefinitionMap)));
  if (isInvalid) {
    // Missing fields have priority over wrong type
    // This has been moved as some transferable checks also perform exist checks internally and fail eventually
    // but that would make type mismatch error appear in place of missing fields scenarios
    const missingFields = fields.map((field, i) => field ? null : fieldNames[i]).filter(Boolean);
    if (missingFields.length) {
      return [generateMissingFieldMessage(missingFields, columnId)];
    }
    if (isWrongType) {
      var _operationDefinition$3, _operationDefinition$4;
      // as fallback show all the fields as invalid?
      const wrongTypeFields = (_operationDefinition$3 = operationDefinition === null || operationDefinition === void 0 ? void 0 : (_operationDefinition$4 = operationDefinition.getNonTransferableFields) === null || _operationDefinition$4 === void 0 ? void 0 : _operationDefinition$4.call(operationDefinition, column, indexPattern)) !== null && _operationDefinition$3 !== void 0 ? _operationDefinition$3 : fieldNames;
      return [{
        uniqueId: _user_messages_ids.FIELD_WRONG_TYPE,
        message: _i18n.i18n.translate('xpack.lens.indexPattern.fieldsWrongType', {
          defaultMessage: '{count, plural, one {Field} other {Fields}} {invalidFields} {count, plural, one {is} other {are}} of the wrong type',
          values: {
            count: wrongTypeFields.length,
            invalidFields: wrongTypeFields.join(', ')
          }
        })
      }];
    }
  }
  return [];
}
const generateMissingFieldMessage = (missingFields, columnId) => ({
  uniqueId: _user_messages_ids.FIELD_NOT_FOUND,
  message: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.lens.indexPattern.fieldsNotFound",
    defaultMessage: "{count, plural, one {Field} other {Fields}} {missingFields} {count, plural, one {was} other {were}} not found.",
    values: {
      count: missingFields.length,
      missingFields: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, missingFields.map((field, index) => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
        key: field,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 116,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 117,
          columnNumber: 17
        }
      }, field), index + 1 === missingFields.length ? '' : ', ')))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 5
    }
  }),
  displayLocations: [{
    id: 'toolbar'
  }, {
    id: 'dimensionButton',
    dimensionId: columnId
  }, {
    id: 'embeddableBadge'
  }]
});
exports.generateMissingFieldMessage = generateMissingFieldMessage;
function getSafeName(name, indexPattern) {
  const field = indexPattern === null || indexPattern === void 0 ? void 0 : indexPattern.getFieldByName(name);
  return field ? field.displayName : _i18n.i18n.translate('xpack.lens.indexPattern.missingFieldLabel', {
    defaultMessage: 'Missing field'
  });
}
function areDecimalsValid(inputValue, digits) {
  const [, decimals = ''] = `${inputValue}`.split('.');
  return decimals.length <= digits;
}
function isValidNumber(inputValue, integer, upperBound, lowerBound, digits = 2) {
  const inputValueAsNumber = Number(inputValue);
  return inputValue !== '' && inputValue != null && !Number.isNaN(inputValueAsNumber) && Number.isFinite(inputValueAsNumber) && (!integer || Number.isInteger(inputValueAsNumber)) && (upperBound === undefined || inputValueAsNumber <= upperBound) && (lowerBound === undefined || inputValueAsNumber >= lowerBound) && areDecimalsValid(inputValue, integer ? 0 : digits);
}
function isColumnOfType(type, column) {
  return column.operationType === type;
}
const isColumn = setter => {
  return 'operationType' in setter;
};
exports.isColumn = isColumn;
function isColumnFormatted(column) {
  return Boolean('params' in column && column.params && 'format' in column.params);
}
function getFormatFromPreviousColumn(previousColumn) {
  return (previousColumn === null || previousColumn === void 0 ? void 0 : previousColumn.dataType) === 'number' && isColumnFormatted(previousColumn) && previousColumn.params ? {
    format: previousColumn.params.format
  } : undefined;
}

// Check the escape argument when used for transitioning comparisons
function getExistsFilter(field, escape = true) {
  return {
    query: escape ? `"${field}": *` : `${field}: *`,
    language: 'kuery'
  };
}

// Useful utility to compare for escape and unescaped exist filters
function comparePreviousColumnFilter(filter, field) {
  return (0, _lodash.isEqual)(filter, getExistsFilter(field)) || (0, _lodash.isEqual)(filter, getExistsFilter(field, false));
}
function getFilter(previousColumn, columnParams) {
  let filter = previousColumn === null || previousColumn === void 0 ? void 0 : previousColumn.filter;
  if (previousColumn && isColumnOfType('last_value', previousColumn) && comparePreviousColumnFilter(filter, previousColumn.sourceField)) {
    return;
  }
  if (columnParams) {
    if ('kql' in columnParams) {
      var _columnParams$kql;
      filter = {
        query: (_columnParams$kql = columnParams.kql) !== null && _columnParams$kql !== void 0 ? _columnParams$kql : '',
        language: 'kuery'
      };
    } else if ('lucene' in columnParams) {
      var _columnParams$lucene;
      filter = {
        query: (_columnParams$lucene = columnParams.lucene) !== null && _columnParams$lucene !== void 0 ? _columnParams$lucene : '',
        language: 'lucene'
      };
    }
  }
  return filter;
}
function isMetricCounterField(field) {
  return (field === null || field === void 0 ? void 0 : field.timeSeriesMetric) === 'counter';
}
function hasStateFormulaColumn(state) {
  return Object.values(state.layers).some(layer => Object.values(layer.columns).some(column => isColumnOfType('formula', column)));
}
function getFormulaColumnsFromLayer(layer) {
  return Object.entries(layer.columns).filter(entry => isColumnOfType('formula', entry[1]));
}
function cleanupFormulaColumns(state) {
  // check whether it makes sense to perform all the work for formula
  if (hasStateFormulaColumn(state)) {
    return state;
  }
  const newState = structuredClone(state);
  for (const layerId of Object.keys(newState.layers)) {
    const layer = newState.layers[layerId];
    const columnsToFilter = new Set();
    const formulaColumns = getFormulaColumnsFromLayer(layer);
    for (const [columnId, column] of formulaColumns) {
      const referencedColumns = (0, _layer_helpers.getReferencedColumnIds)(layer, columnId);
      // Remove references to hidden formula columns
      for (const id of referencedColumns) {
        if (layer.columns[id]) {
          delete layer.columns[id];
          columnsToFilter.add(id);
        }
        delete column.params.isFormulaBroken;
        column.references = [];
      }
    }
    layer.columnOrder = layer.columnOrder.filter(colId => !columnsToFilter.has(colId));
  }
  return newState;
}