"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.injectLensReferences = exports.extractLensReferences = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const injectLensReferences = (state, references = []) => {
  const clonedState = (0, _lodash.cloneDeep)(state);
  if (clonedState.savedObjectId || !clonedState.attributes) {
    return clonedState;
  }

  // TODO: find a way to cull erroneous dashboard references
  const combinedReferences = (0, _lodash.uniqBy)([...references, ...clonedState.attributes.references], 'name');
  clonedState.attributes.references = combinedReferences;
  return clonedState;
};
exports.injectLensReferences = injectLensReferences;
const extractLensReferences = state => {
  var _ref, _state$attributes$ref, _state$attributes;
  return {
    state,
    references: (_ref = (_state$attributes$ref = (_state$attributes = state.attributes) === null || _state$attributes === void 0 ? void 0 : _state$attributes.references) !== null && _state$attributes$ref !== void 0 ? _state$attributes$ref : state.references) !== null && _ref !== void 0 ? _ref : []
  };
};
exports.extractLensReferences = extractLensReferences;