"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.bucketTermsOperationSchema = exports.bucketRangesOperationSchema = exports.bucketOperationDefinitionSchema = exports.bucketHistogramOperationSchema = exports.bucketFiltersOperationSchema = exports.bucketDateHistogramOperationSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _filter = require("./filter");
var _constants = require("./constants");
var _format = require("./format");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const labelSharedProp = {
  /**
   * Label for the operation
   */
  label: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'Label for the operation'
    }
  }))
};
const bucketDateHistogramOperationSchema = exports.bucketDateHistogramOperationSchema = _configSchema.schema.object({
  /**
   * Select bucket operation type
   */
  operation: _configSchema.schema.literal('date_histogram'),
  ...labelSharedProp,
  /**
   * Field to be used for the date histogram
   */
  field: _configSchema.schema.string({
    meta: {
      description: 'Field to be used for the date histogram'
    }
  }),
  /**
   * Suggested interval
   */
  suggested_interval: _configSchema.schema.string({
    defaultValue: _constants.LENS_DATE_HISTOGRAM_INTERVAL_DEFAULT,
    meta: {
      description: 'Suggested interval'
    }
  }),
  /**
   * Whether to use original time range
   */
  use_original_time_range: _configSchema.schema.boolean({
    defaultValue: _constants.LENS_DATE_HISTOGRAM_IGNORE_TIME_RANGE_DEFAULT,
    meta: {
      description: 'Whether to use original time range'
    }
  }),
  /**
   * Whether to include empty rows
   */
  include_empty_rows: _configSchema.schema.boolean({
    defaultValue: _constants.LENS_DATE_HISTOGRAM_EMPTY_ROWS_DEFAULT,
    meta: {
      description: 'Whether to include empty rows'
    }
  }),
  drop_partial_intervals: _configSchema.schema.maybe(_configSchema.schema.boolean({
    defaultValue: false,
    meta: {
      description: 'Whether to drop partial intervals'
    }
  }))
});
const bucketTermsOperationSchema = exports.bucketTermsOperationSchema = _configSchema.schema.object({
  operation: _configSchema.schema.literal('terms'),
  ..._format.formatSchema,
  ...labelSharedProp,
  /**
   * Fields to be used for the terms
   */
  fields: _configSchema.schema.arrayOf(_configSchema.schema.string({
    meta: {
      description: 'Fields to be used for the terms'
    }
  })),
  /**
   * Size of the terms
   */
  size: _configSchema.schema.number({
    defaultValue: _constants.LENS_TERMS_SIZE_DEFAULT,
    meta: {
      description: 'Size of the terms'
    }
  }),
  /**
   * Whether to increase accuracy
   */
  increase_accuracy: _configSchema.schema.maybe(_configSchema.schema.boolean({
    meta: {
      description: 'Whether to increase accuracy'
    }
  })),
  /**
   * Includes
   */
  includes: _configSchema.schema.maybe(_configSchema.schema.object({
    values: _configSchema.schema.arrayOf(_configSchema.schema.string({
      meta: {
        description: 'Values to include'
      }
    })),
    as_regex: _configSchema.schema.maybe(_configSchema.schema.boolean({
      meta: {
        description: 'Whether to use regex'
      }
    }))
  })),
  /**
   * Excludes
   */
  excludes: _configSchema.schema.maybe(_configSchema.schema.object({
    values: _configSchema.schema.arrayOf(_configSchema.schema.string({
      meta: {
        description: 'Values to exclude'
      }
    })),
    as_regex: _configSchema.schema.maybe(_configSchema.schema.boolean({
      meta: {
        description: 'Whether to use regex'
      }
    }))
  })),
  /**
   * Other bucket
   */
  other_bucket: _configSchema.schema.maybe(_configSchema.schema.object({
    include_documents_without_field: _configSchema.schema.boolean({
      meta: {
        description: 'Whether to include documents without field'
      }
    })
  })),
  /**
   * Rank by
   */
  rank_by: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.object({
    type: _configSchema.schema.literal('alphabetical'),
    /**
     * Direction of the alphabetical order
     */
    direction: _configSchema.schema.oneOf([_configSchema.schema.literal('asc'), _configSchema.schema.literal('desc')])
  }), _configSchema.schema.object({
    type: _configSchema.schema.literal('rare'),
    /**
     * Maximum number of rare terms
     */
    max: _configSchema.schema.number({
      meta: {
        description: 'Maximum number of rare terms'
      }
    })
  }), _configSchema.schema.object({
    type: _configSchema.schema.literal('significant')
  }), _configSchema.schema.object({
    type: _configSchema.schema.literal('column'),
    /**
     * Metric to be used for the column
     */
    metric: _configSchema.schema.number({
      meta: {
        description: 'Metric to be used for the column'
      }
    }),
    /**
     * Direction of the column
     */
    direction: _configSchema.schema.oneOf([_configSchema.schema.literal('asc'), _configSchema.schema.literal('desc')])
  }), _configSchema.schema.object({
    type: _configSchema.schema.literal('custom'),
    /**
     * Operation type
     * @TODO handle the different param options for some of these operations
     */
    operation: _configSchema.schema.oneOf([_configSchema.schema.literal('min'), _configSchema.schema.literal('max'), _configSchema.schema.literal('average'), _configSchema.schema.literal('median'), _configSchema.schema.literal('standard_deviation'), _configSchema.schema.literal('unique_count'), _configSchema.schema.literal('percentile'), _configSchema.schema.literal('percentile_rank'), _configSchema.schema.literal('count'), _configSchema.schema.literal('sum'), _configSchema.schema.literal('last_value')]),
    /**
     * Field to be used for the custom operation
     */
    field: _configSchema.schema.string({
      meta: {
        description: 'Field to be used for the custom operation'
      }
    }),
    /**
     * Direction of the custom operation
     */
    direction: _configSchema.schema.oneOf([_configSchema.schema.literal('asc'), _configSchema.schema.literal('desc')])
  })]))
});
const bucketFiltersOperationSchema = exports.bucketFiltersOperationSchema = _configSchema.schema.object({
  operation: _configSchema.schema.literal('filters'),
  ...labelSharedProp,
  /**
   * Filters
   */
  filters: _configSchema.schema.arrayOf(_filter.filterWithLabelSchema)
});
const bucketHistogramOperationSchema = exports.bucketHistogramOperationSchema = _configSchema.schema.object({
  operation: _configSchema.schema.literal('histogram'),
  ..._format.formatSchema,
  ...labelSharedProp,
  /**
   * Label for the operation
   */
  label: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'Label for the operation'
    }
  })),
  /**
   * Field to be used for the histogram
   */
  field: _configSchema.schema.string({
    meta: {
      description: 'Field to be used for the histogram'
    }
  }),
  /**
   * Granularity of the histogram
   */
  granularity: _configSchema.schema.oneOf([_configSchema.schema.number({
    meta: {
      description: 'Granularity of the histogram'
    },
    min: _constants.LENS_HISTOGRAM_GRANULARITY_MIN,
    max: _constants.LENS_HISTOGRAM_GRANULARITY_MAX
  }), _configSchema.schema.literal('auto')], {
    defaultValue: _constants.LENS_HISTOGRAM_GRANULARITY_DEFAULT_VALUE
  }),
  /**
   * Whether to include empty rows
   */
  include_empty_rows: _configSchema.schema.boolean({
    meta: {
      description: 'Whether to include empty rows'
    },
    defaultValue: _constants.LENS_HISTOGRAM_EMPTY_ROWS_DEFAULT
  })
});
const bucketRangesOperationSchema = exports.bucketRangesOperationSchema = _configSchema.schema.object({
  operation: _configSchema.schema.literal('range'),
  ..._format.formatSchema,
  ...labelSharedProp,
  /**
   * Label for the operation
   */
  label: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'Label for the operation'
    }
  })),
  /**
   * Field to be used for the range
   */
  field: _configSchema.schema.string({
    meta: {
      description: 'Field to be used for the range'
    }
  }),
  /**
   * Ranges
   */
  ranges: _configSchema.schema.arrayOf(_configSchema.schema.object({
    /**
     * Less than or equal to
     */
    lte: _configSchema.schema.maybe(_configSchema.schema.number({
      meta: {
        description: 'Less than or equal to'
      }
    })),
    /**
     * Greater than
     */
    gt: _configSchema.schema.maybe(_configSchema.schema.number({
      meta: {
        description: 'Greater than'
      }
    })),
    /**
     * Label
     */
    label: _configSchema.schema.maybe(_configSchema.schema.string({
      meta: {
        description: 'Label'
      }
    }))
  }))
});
const bucketOperationDefinitionSchema = exports.bucketOperationDefinitionSchema = _configSchema.schema.oneOf([bucketDateHistogramOperationSchema, bucketTermsOperationSchema, bucketHistogramOperationSchema, bucketRangesOperationSchema, bucketFiltersOperationSchema]);