"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFormulaColumn = getFormulaColumn;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function getFormulaColumn(id, config, dataView, baseLayer) {
  var _baseLayer$columnOrde, _baseLayer$columns;
  const {
    format,
    label,
    formula,
    ...column
  } = config;
  const formulaColumn = {
    operationType: 'formula',
    isBucketed: false,
    dataType: 'number',
    references: [],
    label: label !== null && label !== void 0 ? label : formula,
    ...column,
    params: {
      formula,
      format
    }
  };
  const formulaLayer = {
    ...baseLayer,
    columnOrder: ((_baseLayer$columnOrde = baseLayer === null || baseLayer === void 0 ? void 0 : baseLayer.columnOrder) !== null && _baseLayer$columnOrde !== void 0 ? _baseLayer$columnOrde : []).concat(id),
    columns: {
      ...((_baseLayer$columns = baseLayer === null || baseLayer === void 0 ? void 0 : baseLayer.columns) !== null && _baseLayer$columns !== void 0 ? _baseLayer$columns : {}),
      [id]: {
        ...formulaColumn,
        customLabel: true
      }
    }
  };
  if (!formulaLayer) {
    throw new Error('Error generating the data layer for the chart');
  }
  return formulaLayer;
}