"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getHistogramColumn = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getHistogramColumn = ({
  options
}) => {
  var _options$params, _options$sourceField;
  const {
    interval = 'auto',
    ...rest
  } = (_options$params = options === null || options === void 0 ? void 0 : options.params) !== null && _options$params !== void 0 ? _options$params : {};
  return {
    dataType: 'date',
    isBucketed: true,
    label: '@timestamp',
    operationType: 'date_histogram',
    scale: 'interval',
    sourceField: (_options$sourceField = options === null || options === void 0 ? void 0 : options.sourceField) !== null && _options$sourceField !== void 0 ? _options$sourceField : '@timestamp',
    params: {
      interval,
      ...rest
    }
  };
};
exports.getHistogramColumn = getHistogramColumn;