"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DotExpander = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _shared_imports = require("../../../../../../shared_imports");
var _field_name_field = require("./common_fields/field_name_field");
var _shared = require("./shared");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ingest_pipelines/public/application/components/pipeline_editor/components/processor_form/processors/dot_expander.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const fieldsConfig = {
  /* Optional fields config */
  path: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    serializer: _shared.from.emptyStringToUndefined,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.dotExpanderForm.pathFieldLabel', {
      defaultMessage: 'Path'
    }),
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.dotExpanderForm.pathHelpText', {
      defaultMessage: 'Output field. Only required if the field to expand is part another object field.'
    })
  },
  override: {
    type: _shared_imports.FIELD_TYPES.TOGGLE,
    defaultValue: false,
    deserializer: _shared.to.booleanOrUndef,
    serializer: _shared.from.undefinedIfValue(false),
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.dotExpanderForm.overrideFieldLabel', {
      defaultMessage: 'Override'
    }),
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.dotExpanderForm.overrideFieldHelpText', {
      defaultMessage: 'Controls the behavior when there is already an existing nested object that conflicts with the expanded field. When disabled, the processor will merge conflicts by combining the old and the new values into an array. If enabled, the value from the expanded field will overwrite the existing value.'
    })
  }
};
const DotExpander = () => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_field_name_field.FieldNameField, {
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.dotExpanderForm.fieldNameHelpText', {
      defaultMessage: 'Field containing dot notation.'
    }),
    additionalValidations: [{
      validator: ({
        value
      }) => {
        if (typeof value === 'string' && value.length) {
          const allowedPattern = value.includes('.') || value === '*';
          return !allowedPattern ? {
            message: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.dotExpanderForm.fieldNameRequiresDotError', {
              defaultMessage: 'The field name must be an asterisk or contain a dot character.'
            })
          } : undefined;
        }
      }
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    "data-test-subj": "pathField",
    config: fieldsConfig.path,
    component: _shared_imports.Field,
    path: "fields.path",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    "data-test-subj": "overrideField",
    config: fieldsConfig.override,
    component: _shared_imports.ToggleField,
    path: "fields.override",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 7
    }
  }));
};
exports.DotExpander = DotExpander;