"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PipelineProcessorsItemStatus = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _shared = require("./shared");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ingest_pipelines/public/application/components/pipeline_editor/components/pipeline_processors_editor_item_status.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const processorStatusToIconMap = {
  success: {
    icon: 'checkInCircleFilled',
    iconColor: 'success',
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditorItem.successStatusAriaLabel', {
      defaultMessage: 'Success'
    })
  },
  error: {
    icon: _shared.ErrorIcon,
    iconColor: 'danger',
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditorItem.errorStatusAriaLabel', {
      defaultMessage: 'Error'
    })
  },
  error_ignored: {
    icon: _shared.ErrorIgnoredIcon,
    iconColor: 'danger',
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditorItem.errorIgnoredStatusAriaLabel', {
      defaultMessage: 'Error ignored'
    })
  },
  dropped: {
    icon: 'indexClose',
    iconColor: 'subdued',
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditorItem.droppedStatusAriaLabel', {
      defaultMessage: 'Dropped'
    })
  },
  skipped: {
    icon: _shared.SkippedIcon,
    iconColor: 'subdued',
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditorItem.skippedStatusAriaLabel', {
      defaultMessage: 'Skipped'
    })
  },
  inactive: {
    icon: 'dot',
    iconColor: '#D3DAE6',
    // $euiColorLightShade
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditorItem.inactiveStatusAriaLabel', {
      defaultMessage: 'Not run'
    })
  }
};

// This is a fallback in case ES returns a status we do not support
// This is not expected and likely means we need to modify the code to support a new status
const unknownStatus = {
  icon: 'dot',
  iconColor: '#D3DAE6',
  // $euiColorLightShade
  label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditorItem.unknownStatusAriaLabel', {
    defaultMessage: 'Unknown'
  })
};
const PipelineProcessorsItemStatus = ({
  processorStatus
}) => {
  const {
    icon,
    iconColor,
    label
  } = processorStatusToIconMap[processorStatus] || unknownStatus;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 16
      }
    }, label),
    position: "top",
    type: icon,
    color: iconColor,
    "aria-label": label,
    size: "s",
    iconProps: {
      'data-test-subj': 'processorStatusIcon'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 5
    }
  });
};
exports.PipelineProcessorsItemStatus = PipelineProcessorsItemStatus;