"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UnifiedSearchBar = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _metrics_source = require("../../containers/metrics_source");
var _use_kibana = require("../../hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/shared/unified_search_bar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const UnifiedSearchBar = ({
  onQuerySubmit,
  showDatePicker = false,
  showSubmitButton = false,
  showFilterBar = false,
  showQueryMenu = false,
  useDefaultBehaviors = true,
  query,
  placeholder,
  showPlaceholder = true
}) => {
  const {
    metricsView
  } = (0, _metrics_source.useMetricsDataViewContext)();
  const {
    services: {
      unifiedSearch
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    SearchBar
  } = unifiedSearch.ui;
  return /*#__PURE__*/_react.default.createElement(SearchBar, {
    appName: 'infra',
    displayStyle: "inPage",
    iconType: "search",
    indexPatterns: metricsView && [metricsView.dataViewReference],
    placeholder: showPlaceholder ? placeholder !== null && placeholder !== void 0 ? placeholder : _i18n.i18n.translate('xpack.infra.homePage.toolbar.kqlSearchFieldPlaceholder', {
      defaultMessage: 'Search for infrastructure data… (e.g. host.name:host-1)'
    }) : undefined,
    showSubmitButton: showSubmitButton,
    onQuerySubmit: onQuerySubmit,
    allowSavingQueries: true,
    showDatePicker: showDatePicker,
    showFilterBar: showFilterBar,
    showQueryInput: true,
    showQueryMenu: showQueryMenu,
    useDefaultBehaviors: useDefaultBehaviors,
    query: query,
    isAutoRefreshDisabled: true,
    isRefreshPaused: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 5
    }
  });
};
exports.UnifiedSearchBar = UnifiedSearchBar;