"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InferencePlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _output = require("../common/output");
var _chat_complete = require("../common/rest/chat_complete");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class InferencePlugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    this.logger = context.logger.get();
  }
  setup(coreSetup, pluginsSetup) {
    return {};
  }
  start(coreStart, pluginsStart) {
    const chatComplete = (0, _chat_complete.createChatCompleteRestApi)({
      fetch: coreStart.http.fetch
    });
    const output = (0, _output.createOutputApi)(chatComplete);
    return {
      chatComplete,
      output,
      getConnectors: async () => {
        const res = await coreStart.http.get('/internal/inference/connectors');
        return res.connectors;
      }
    };
  }
}
exports.InferencePlugin = InferencePlugin;