"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepLogistics = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _shared_imports = require("../../../../shared_imports");
var _shared = require("../../shared");
var _documentation = require("../../../services/documentation");
var _template_form_schemas = require("../template_form_schemas");
var _constants = require("../../../../../common/constants");
var _index_mode_labels = require("../../../lib/index_mode_labels");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/template_form/steps/step_logistics.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// Create or Form components with partial props that are common to all instances
const UseField = (0, _shared_imports.getUseField)({
  component: _shared_imports.Field
});
const FormRow = (0, _shared_imports.getFormRow)({
  titleTag: 'h3'
});
function getFieldsMeta(esDocsBase) {
  return {
    name: {
      title: _i18n.i18n.translate('xpack.idxMgmt.templateForm.stepLogistics.nameTitle', {
        defaultMessage: 'Name'
      }),
      description: _i18n.i18n.translate('xpack.idxMgmt.templateForm.stepLogistics.nameDescription', {
        defaultMessage: 'A unique identifier for this template.'
      }),
      testSubject: 'nameField'
    },
    indexPatterns: {
      title: _i18n.i18n.translate('xpack.idxMgmt.templateForm.stepLogistics.indexPatternsTitle', {
        defaultMessage: 'Index patterns'
      }),
      description: _i18n.i18n.translate('xpack.idxMgmt.templateForm.stepLogistics.indexPatternsDescription', {
        defaultMessage: 'The index patterns to apply to the template.'
      }),
      testSubject: 'indexPatternsField'
    },
    createDataStream: {
      title: _i18n.i18n.translate('xpack.idxMgmt.templateForm.stepLogistics.dataStreamTitle', {
        defaultMessage: 'Data stream'
      }),
      description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.templateForm.stepLogistics.dataStreamDescription",
        defaultMessage: "The template creates data streams instead of indices. {docsLink}",
        values: {
          docsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: _documentation.documentationService.getDataStreamsDocumentationLink(),
            target: "_blank",
            external: true,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 85,
              columnNumber: 15
            }
          }, _i18n.i18n.translate('xpack.idxMgmt.templateForm.stepLogistics.dataStreamDocumentionLink', {
            defaultMessage: 'Learn more.'
          }))
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 80,
          columnNumber: 9
        }
      }),
      testSubject: 'dataStreamField'
    },
    indexMode: {
      title: _i18n.i18n.translate('xpack.idxMgmt.templateForm.stepLogistics.indexModeTitle', {
        defaultMessage: 'Index mode'
      }),
      description: _i18n.i18n.translate('xpack.idxMgmt.templateForm.stepLogistics.indexModeDescription', {
        defaultMessage: 'The index.mode setting is used to control settings applied in specific domains like ingestions of time series data or logs.'
      }),
      options: [{
        value: _constants.STANDARD_INDEX_MODE,
        inputDisplay: _index_mode_labels.indexModeLabels[_constants.STANDARD_INDEX_MODE],
        'data-test-subj': 'index_mode_standard',
        dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.Fragment, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 117,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement("strong", {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 118,
            columnNumber: 15
          }
        }, _index_mode_labels.indexModeLabels[_constants.STANDARD_INDEX_MODE]), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "s",
          color: "subdued",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 119,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement("p", {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 120,
            columnNumber: 17
          }
        }, _index_mode_labels.indexModeDescriptions[_constants.STANDARD_INDEX_MODE])))
      }, {
        value: _constants.TIME_SERIES_MODE,
        inputDisplay: _index_mode_labels.indexModeLabels[_constants.TIME_SERIES_MODE],
        'data-test-subj': 'index_mode_time_series',
        dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.Fragment, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 130,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement("strong", {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 131,
            columnNumber: 15
          }
        }, _index_mode_labels.indexModeLabels[_constants.TIME_SERIES_MODE]), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "s",
          color: "subdued",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 132,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement("p", {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 133,
            columnNumber: 17
          }
        }, _index_mode_labels.indexModeDescriptions[_constants.TIME_SERIES_MODE])))
      }, {
        value: _constants.LOGSDB_INDEX_MODE,
        inputDisplay: _index_mode_labels.indexModeLabels[_constants.LOGSDB_INDEX_MODE],
        'data-test-subj': 'index_mode_logsdb',
        dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.Fragment, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 143,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement("strong", {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 144,
            columnNumber: 15
          }
        }, _index_mode_labels.indexModeLabels[_constants.LOGSDB_INDEX_MODE]), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "s",
          color: "subdued",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 145,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement("p", {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 146,
            columnNumber: 17
          }
        }, _index_mode_labels.indexModeDescriptions[_constants.LOGSDB_INDEX_MODE])))
      }, {
        value: _constants.LOOKUP_INDEX_MODE,
        inputDisplay: _index_mode_labels.indexModeLabels[_constants.LOOKUP_INDEX_MODE],
        'data-test-subj': 'index_mode_logsdb',
        dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.Fragment, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 156,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement("strong", {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 157,
            columnNumber: 15
          }
        }, _index_mode_labels.indexModeLabels[_constants.LOOKUP_INDEX_MODE]), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "s",
          color: "subdued",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 158,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement("p", {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 159,
            columnNumber: 17
          }
        }, _index_mode_labels.indexModeDescriptions[_constants.LOOKUP_INDEX_MODE])))
      }],
      testSubject: 'indexModeField'
    },
    order: {
      title: _i18n.i18n.translate('xpack.idxMgmt.templateForm.stepLogistics.orderTitle', {
        defaultMessage: 'Merge order'
      }),
      description: _i18n.i18n.translate('xpack.idxMgmt.templateForm.stepLogistics.orderDescription', {
        defaultMessage: 'The merge order when multiple templates match an index.'
      }),
      testSubject: 'orderField'
    },
    priority: {
      title: _i18n.i18n.translate('xpack.idxMgmt.templateForm.stepLogistics.priorityTitle', {
        defaultMessage: 'Priority'
      }),
      description: _i18n.i18n.translate('xpack.idxMgmt.templateForm.stepLogistics.priorityDescription', {
        defaultMessage: 'Only the highest priority template will be applied.'
      }),
      testSubject: 'priorityField'
    },
    version: {
      title: _i18n.i18n.translate('xpack.idxMgmt.templateForm.stepLogistics.versionTitle', {
        defaultMessage: 'Version'
      }),
      description: _i18n.i18n.translate('xpack.idxMgmt.templateForm.stepLogistics.versionDescription', {
        defaultMessage: 'A number that identifies the template to external management systems.'
      }),
      testSubject: 'versionField'
    },
    dataRetention: {
      title: _i18n.i18n.translate('xpack.idxMgmt.templateForm.stepLogistics.dataRetentionTitle', {
        defaultMessage: 'Data retention'
      }),
      description: _i18n.i18n.translate('xpack.idxMgmt.templateForm.stepLogistics.dataRetentionDescription', {
        defaultMessage: 'Data will be kept at least this long before being automatically deleted.'
      }),
      unitTestSubject: 'unitDataRetentionField'
    },
    allowAutoCreate: {
      title: _i18n.i18n.translate('xpack.idxMgmt.templateForm.stepLogistics.allowAutoCreateTitle', {
        defaultMessage: 'Allow auto create'
      }),
      description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.templateForm.stepLogistics.allowAutoCreateDescription",
        defaultMessage: "This setting overwrites the value of the {settingName} cluster setting. If set to {true} in a template, then indices can be automatically created using that template.",
        values: {
          settingName: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 216,
              columnNumber: 26
            }
          }, "action.auto_create_index"),
          true: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 217,
              columnNumber: 19
            }
          }, "true")
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 212,
          columnNumber: 9
        }
      }),
      testSubject: 'allowAutoCreateField'
    }
  };
}
function formDeserializer(formData) {
  return {
    ...formData,
    addMeta: Boolean(formData._meta && Object.keys(formData._meta).length),
    doCreateDataStream: Boolean(formData.dataStream),
    setIndexMode: Boolean(formData.indexMode)
  };
}
function getformSerializer(initialTemplateData = {}) {
  return formData => {
    var _initialTemplateData$;
    const {
      addMeta,
      doCreateDataStream,
      setIndexMode,
      indexMode: indexModeValue,
      ...rest
    } = formData;
    const dataStream = doCreateDataStream ? (_initialTemplateData$ = initialTemplateData.dataStream) !== null && _initialTemplateData$ !== void 0 ? _initialTemplateData$ : {} : undefined;
    const indexMode = setIndexMode ? indexModeValue : undefined;
    return {
      ...rest,
      dataStream,
      indexMode
    };
  };
}
const StepLogistics = exports.StepLogistics = /*#__PURE__*/_react.default.memo(({
  defaultValue,
  isEditing = false,
  onChange,
  isLegacy = false
}) => {
  const {
    form
  } = (0, _shared_imports.useForm)({
    schema: _template_form_schemas.schemas.logistics,
    defaultValue,
    options: {
      stripEmptyFields: false
    },
    serializer: getformSerializer(defaultValue),
    deserializer: formDeserializer
  });
  const {
    submit,
    isSubmitted,
    isSubmitting,
    isValid: isFormValid,
    getErrors: getFormErrors,
    getFormData,
    setFieldValue,
    updateFieldValues
  } = form;
  const [{
    addMeta,
    doCreateDataStream,
    lifecycle,
    indexPatterns: indexPatternsField,
    setIndexMode
  }] = (0, _shared_imports.useFormData)({
    form,
    watch: ['addMeta', 'lifecycle.enabled', 'lifecycle.infiniteDataRetention', 'doCreateDataStream', 'indexPatterns', 'indexMode', 'setIndexMode']
  });
  (0, _react.useEffect)(() => {
    if (!setIndexMode) {
      setFieldValue('indexMode', null);
    }
  }, [setIndexMode, setFieldValue]);
  (0, _react.useEffect)(() => {
    if (indexPatternsField && indexPatternsField.length === 1 && indexPatternsField[0] === 'logs-*-*' &&
    // Only set index mode if index pattern was changed
    defaultValue.indexPatterns !== indexPatternsField) {
      updateFieldValues({
        setIndexMode: true,
        indexMode: _constants.LOGSDB_INDEX_MODE
      });
    }
  }, [defaultValue.indexPatterns, indexPatternsField, updateFieldValues]);

  /**
   * When the consumer call validate() on this step, we submit the form so it enters the "isSubmitted" state
   * and we can display the form errors on top of the forms if there are any.
   */
  const validate = (0, _react.useCallback)(async () => {
    return (await submit()).isValid;
  }, [submit]);
  (0, _react.useEffect)(() => {
    onChange({
      isValid: isFormValid,
      getData: getFormData,
      validate
    });
  }, [onChange, isFormValid, validate, getFormData]);
  const {
    name,
    indexPatterns,
    createDataStream,
    indexMode,
    order,
    priority,
    version,
    dataRetention,
    allowAutoCreate
  } = getFieldsMeta(_documentation.documentationService.getEsDocsBase());
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 361,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 362,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 363,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    "data-test-subj": "stepTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 364,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.templateForm.stepLogistics.stepTitle",
    defaultMessage: "Logistics",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 365,
      columnNumber: 17
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 373,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    flush: "right",
    href: _documentation.documentationService.getTemplatesDocumentationLink(isLegacy),
    target: "_blank",
    iconType: "question",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 374,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.templateForm.stepLogistics.docsButtonLabel",
    defaultMessage: "Index Templates docs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 381,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 389,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.Form, {
    form: form,
    isInvalid: isSubmitted && !isSubmitting && !isFormValid,
    error: getFormErrors(),
    "data-test-subj": "stepLogistics",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 391,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(FormRow, {
    title: name.title,
    description: name.description,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 398,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(UseField, {
    path: "name",
    componentProps: {
      ['data-test-subj']: name.testSubject,
      euiFieldProps: {
        disabled: isEditing
      }
    },
    config: isEditing ? _template_form_schemas.nameConfigWithoutValidations : _template_form_schemas.nameConfig,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 399,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(FormRow, {
    title: indexPatterns.title,
    description: indexPatterns.description,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 410,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(UseField, {
    path: "indexPatterns",
    componentProps: {
      ['data-test-subj']: indexPatterns.testSubject
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 411,
      columnNumber: 13
    }
  })), isLegacy !== true && /*#__PURE__*/_react.default.createElement(FormRow, {
    title: createDataStream.title,
    description: createDataStream.description,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 421,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(UseField, {
    path: "doCreateDataStream",
    componentProps: {
      'data-test-subj': createDataStream.testSubject
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 422,
      columnNumber: 15
    }
  })), doCreateDataStream && /*#__PURE__*/_react.default.createElement(FormRow, {
    title: dataRetention.title,
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, dataRetention.description, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 439,
        columnNumber: 19
      }
    }), /*#__PURE__*/_react.default.createElement(UseField, {
      path: "lifecycle.enabled",
      componentProps: {
        'data-test-subj': 'dataRetentionToggle'
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 440,
        columnNumber: 19
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 434,
      columnNumber: 13
    }
  }, (lifecycle === null || lifecycle === void 0 ? void 0 : lifecycle.enabled) && /*#__PURE__*/_react.default.createElement(UseField, {
    path: "lifecycle.value",
    component: _shared_imports.NumericField,
    labelAppend: /*#__PURE__*/_react.default.createElement(UseField, {
      path: "lifecycle.infiniteDataRetention",
      "data-test-subj": "infiniteDataRetentionToggle",
      componentProps: {
        euiFieldProps: {
          compressed: true
        }
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 452,
        columnNumber: 21
      }
    }),
    componentProps: {
      euiFieldProps: {
        disabled: lifecycle === null || lifecycle === void 0 ? void 0 : lifecycle.infiniteDataRetention,
        'data-test-subj': 'valueDataRetentionField',
        min: 1,
        append: /*#__PURE__*/_react.default.createElement(_shared.UnitField, {
          path: "lifecycle.unit",
          options: _shared.timeUnits,
          disabled: lifecycle === null || lifecycle === void 0 ? void 0 : lifecycle.infiniteDataRetention,
          euiFieldProps: {
            'data-test-subj': 'unitDataRetentionField'
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 468,
            columnNumber: 25
          }
        })
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 448,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(FormRow, {
    title: indexMode.title,
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, indexMode.description, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 490,
        columnNumber: 17
      }
    }), /*#__PURE__*/_react.default.createElement(UseField, {
      path: "setIndexMode",
      component: _shared_imports.ToggleField,
      componentProps: {
        'data-test-subj': 'toggleIndexMode',
        euiFieldProps: {
          label: _i18n.i18n.translate('xpack.idxMgmt.templateForm.stepLogistics.toggleIndexModeLabel', {
            defaultMessage: 'Set index mode'
          })
        }
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 491,
        columnNumber: 17
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 485,
      columnNumber: 11
    }
  }, setIndexMode && /*#__PURE__*/_react.default.createElement(UseField, {
    path: "indexMode",
    componentProps: {
      euiFieldProps: {
        hasDividers: true,
        'data-test-subj': indexMode.testSubject,
        options: indexMode.options
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 510,
      columnNumber: 15
    }
  })), isLegacy && /*#__PURE__*/_react.default.createElement(FormRow, {
    title: order.title,
    description: order.description,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 525,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(UseField, {
    path: "order",
    componentProps: {
      ['data-test-subj']: order.testSubject
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 526,
      columnNumber: 15
    }
  })), isLegacy === false && /*#__PURE__*/_react.default.createElement(FormRow, {
    title: priority.title,
    description: priority.description,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 537,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(UseField, {
    path: "priority",
    componentProps: {
      ['data-test-subj']: priority.testSubject
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 538,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(FormRow, {
    title: version.title,
    description: version.description,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 548,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(UseField, {
    path: "version",
    componentProps: {
      ['data-test-subj']: version.testSubject
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 549,
      columnNumber: 13
    }
  })), isLegacy === false && /*#__PURE__*/_react.default.createElement(FormRow, {
    title: allowAutoCreate.title,
    description: allowAutoCreate.description,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 559,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(UseField, {
    path: "allowAutoCreate",
    component: _shared_imports.RadioGroupField,
    componentProps: {
      'data-test-subj': allowAutoCreate.testSubject,
      euiFieldProps: {
        options: _constants.allowAutoCreateRadios,
        name: 'allowAutoCreate radio group'
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 560,
      columnNumber: 15
    }
  })), isLegacy === false && /*#__PURE__*/_react.default.createElement(FormRow, {
    title: _i18n.i18n.translate('xpack.idxMgmt.templateForm.stepLogistics.metaFieldTitle', {
      defaultMessage: '_meta field'
    }),
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.templateForm.stepLogistics.metaFieldDescription",
      defaultMessage: "Use the _meta field to store any metadata you want.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 582,
        columnNumber: 19
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 586,
        columnNumber: 19
      }
    }), /*#__PURE__*/_react.default.createElement(UseField, {
      path: "addMeta",
      "data-test-subj": "metaToggle",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 587,
        columnNumber: 19
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 576,
      columnNumber: 13
    }
  }, addMeta && /*#__PURE__*/_react.default.createElement(UseField, {
    path: "_meta",
    component: _shared_imports.JsonEditorField,
    componentProps: {
      codeEditorProps: {
        height: '280px',
        'aria-label': _i18n.i18n.translate('xpack.idxMgmt.templateForm.stepLogistics.metaFieldEditorAriaLabel', {
          defaultMessage: '_meta field data editor'
        }),
        'data-test-subj': 'metaField'
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 592,
      columnNumber: 17
    }
  }))));
});