"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SnapshotPoliciesField = void 0;
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../../../shared_imports");
var _api = require("../../../../../services/api");
var _form = require("../../../form");
var _ = require("../..");
var _i18n_texts = require("../../../i18n_texts");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/index_lifecycle_management/public/application/sections/edit_policy/components/phases/shared_fields/snapshot_policies_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const waitForSnapshotFormField = 'phases.delete.actions.wait_for_snapshot.policy';
const SnapshotPoliciesField = () => {
  const {
    services: {
      docLinks,
      getUrlForApp
    }
  } = (0, _shared_imports.useKibana)();
  const {
    error,
    isLoading,
    data,
    resendRequest
  } = (0, _api.useLoadSnapshotPolicies)();
  const [formData] = (0, _shared_imports.useFormData)({
    watch: waitForSnapshotFormField
  });
  const selectedSnapshotPolicy = (0, _lodash.get)(formData, waitForSnapshotFormField);
  const policies = data.map(name => ({
    label: name,
    value: name
  }));
  const getUrlForSnapshotPolicyWizard = () => {
    return getUrlForApp('management', {
      path: `data/snapshot_restore/add_policy`
    });
  };
  let calloutContent;
  if (error) {
    calloutContent = /*#__PURE__*/_react.default.createElement(_.FieldLoadingError, {
      resendRequest: resendRequest,
      "data-test-subj": "policiesErrorCallout",
      "aria-label": _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.deletePhase.reloadPoliciesLabel', {
        defaultMessage: 'Reload policies'
      }),
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.indexLifecycleMgmt.editPolicy.deletePhase.noPoliciesLoadedTitle",
        defaultMessage: "Unable to load existing policies",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 61,
          columnNumber: 11
        }
      }),
      body: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.indexLifecycleMgmt.editPolicy.deletePhase.noPoliciesLoadedMessage",
        defaultMessage: "Refresh this field and enter the name of an existing snapshot policy.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 67,
          columnNumber: 11
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 7
      }
    });
  } else if (data.length === 0) {
    calloutContent = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      announceOnMount: false,
      "data-test-subj": "noPoliciesCallout",
      color: "warning",
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.indexLifecycleMgmt.editPolicy.deletePhase.noPoliciesCreatedTitle",
        defaultMessage: "No snapshot policies found",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 83,
          columnNumber: 13
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.indexLifecycleMgmt.editPolicy.deletePhase.noPoliciesCreatedMessage",
      defaultMessage: "{link} to automate the creation and deletion of cluster snapshots.",
      values: {
        link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: getUrlForSnapshotPolicyWizard(),
          target: "_blank",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 94,
            columnNumber: 17
          }
        }, _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.deletePhase.noPoliciesCreatedLink', {
          defaultMessage: 'Create a snapshot lifecycle policy'
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 11
      }
    })));
  } else if (selectedSnapshotPolicy && !data.includes(selectedSnapshotPolicy)) {
    calloutContent = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      announceOnMount: false,
      "data-test-subj": "customPolicyCallout",
      color: "warning",
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.indexLifecycleMgmt.editPolicy.deletePhase.customPolicyTitle",
        defaultMessage: "Policy name not found",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 117,
          columnNumber: 13
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.indexLifecycleMgmt.editPolicy.deletePhase.customPolicyMessage",
      defaultMessage: "Enter the name of an existing snapshot policy, or {link} with this name.",
      values: {
        link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: getUrlForSnapshotPolicyWizard(),
          target: "_blank",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 128,
            columnNumber: 17
          }
        }, _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.deletePhase.customPolicyLink', {
          defaultMessage: 'create a new policy'
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 123,
        columnNumber: 11
      }
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 146,
        columnNumber: 14
      }
    }, _i18n_texts.i18nTexts.editPolicy.waitForSnapshotLabel),
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.indexLifecycleMgmt.editPolicy.deletePhase.waitForSnapshotDescription",
      defaultMessage: "Specify a snapshot policy to be executed before the deletion of the index. This ensures that a snapshot of the deleted index is available.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 149,
        columnNumber: 11
      }
    }), ' ', /*#__PURE__*/_react.default.createElement(_.LearnMoreLink, {
      docPath: docLinks.links.elasticsearch.ilmWaitForSnapshot,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 153,
        columnNumber: 11
      }
    })),
    titleSize: "xs",
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_form.UseField, {
    path: waitForSnapshotFormField,
    componentProps: {
      label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.indexLifecycleMgmt.editPolicy.deletePhase.waitForSnapshotLabel",
        defaultMessage: "Snapshot policy name",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 165,
          columnNumber: 17
        }
      }), /*#__PURE__*/_react.default.createElement(_.OptionalLabel, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 169,
          columnNumber: 17
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 9
    }
  }, field => {
    const singleSelectionArray = field.value ? [field.value] : [];
    return /*#__PURE__*/_react.default.createElement(_shared_imports.ComboBoxField, {
      field: {
        ...field,
        value: singleSelectionArray
      },
      euiFieldProps: {
        'data-test-subj': 'snapshotPolicyCombobox',
        fullWidth: false,
        options: policies,
        singleSelection: {
          asPlainText: true
        },
        isLoading,
        noSuggestions: !!(error || data.length === 0),
        onCreateOption: newOption => {
          field.setValue(newOption);
        },
        onChange: options => {
          if (options.length > 0) {
            field.setValue(options[0].label);
          } else {
            field.setValue('');
          }
        }
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 180,
        columnNumber: 15
      }
    });
  }), calloutContent));
};
exports.SnapshotPoliciesField = SnapshotPoliciesField;