"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DownsampleField = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _unit_field = require("./unit_field");
var _constants = require("../../../constants");
var _form = require("../../../form");
var _shared_imports = require("../../../../../../shared_imports");
var _described_form_row = require("../../described_form_row");
var _i18n_texts = require("../../../i18n_texts");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/index_lifecycle_management/public/application/sections/edit_policy/components/phases/shared_fields/downsample_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// import { LearnMoreLink } from '../../learn_more_link';
const DownsampleField = ({
  phase
}) => {
  // const { docLinks } = useKibana().services;

  const downsampleEnabledPath = `_meta.${phase}.downsample.enabled`;
  const downsampleIntervalSizePath = `_meta.${phase}.downsample.fixedIntervalSize`;
  const downsampleIntervalUnitsPath = `_meta.${phase}.downsample.fixedIntervalUnits`;
  return /*#__PURE__*/_react.default.createElement(_described_form_row.ToggleFieldWithDescribedFormRow, {
    title: /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 33,
        columnNumber: 14
      }
    }, _i18n_texts.i18nTexts.editPolicy.downsampleLabel),
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 35,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.indexLifecycleMgmt.editPolicy.downsampleDescription",
      defaultMessage: "Roll up documents within a fixed interval to a single summary document. Reduces the index footprint by storing time series data at reduced granularity.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 36,
        columnNumber: 11
      }
    }), ' '),
    fullWidth: true,
    titleSize: "xs",
    switchProps: {
      'data-test-subj': `${phase}-downsampleSwitch`,
      path: downsampleEnabledPath
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_form.UseField, {
    path: downsampleIntervalSizePath,
    key: downsampleIntervalSizePath,
    component: _shared_imports.NumericField,
    componentProps: {
      fullWidth: false,
      euiFieldProps: {
        'data-test-subj': `${phase}-downsampleFixedInterval`,
        min: 1,
        append: /*#__PURE__*/_react.default.createElement(_unit_field.UnitField, {
          path: downsampleIntervalUnitsPath,
          options: _constants.timeUnits,
          euiFieldProps: {
            'data-test-subj': `${phase}-downsampleFixedIntervalUnits`,
            'aria-label': _i18n_texts.i18nTexts.editPolicy.downsampleIntervalFieldUnitsLabel
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 61,
            columnNumber: 15
          }
        })
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 7
    }
  }));
};
exports.DownsampleField = DownsampleField;