"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApiKeyField = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _hooks = require("../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/components/api_key_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ApiKeyField = ({
  apiKeyId,
  length,
  sendGetAPIKey,
  tokenGetter
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    notifications
  } = (0, _hooks.useStartServices)();
  const [state, setState] = (0, _react.useState)('HIDDEN');
  const [key, setKey] = (0, _react.useState)();
  const tokenMask = (0, _react.useMemo)(() => '•'.repeat(length), [length]);
  const toggleKey = async () => {
    if (state === 'VISIBLE') {
      setState('HIDDEN');
    } else if (state === 'HIDDEN') {
      try {
        setState('LOADING');
        const res = await sendGetAPIKey(apiKeyId);
        if (res.error) {
          throw res.error;
        }
        setKey(tokenGetter(res));
        setState('VISIBLE');
      } catch (err) {
        notifications.toasts.addError(err, {
          title: 'Error'
        });
        setState('HIDDEN');
      }
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs",
    css: (0, _react2.css)`
            font-family: ${euiTheme.font.familyCode};
          `,
    "data-test-subj": "apiKeyField",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 9
    }
  }, state === 'VISIBLE' ? key : tokenMask)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: state === 'VISIBLE' ? _i18n.i18n.translate('xpack.fleet.enrollmentTokensList.hideTokenButtonLabel', {
      defaultMessage: 'Hide token'
    }) : _i18n.i18n.translate('xpack.fleet.enrollmentTokensList.showTokenButtonLabel', {
      defaultMessage: 'Show token'
    }),
    disableScreenReaderOutput: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": state === 'VISIBLE' ? _i18n.i18n.translate('xpack.fleet.enrollmentTokensList.hideTokenButtonLabel', {
      defaultMessage: 'Hide token'
    }) : _i18n.i18n.translate('xpack.fleet.enrollmentTokensList.showTokenButtonLabel', {
      defaultMessage: 'Show token'
    }),
    color: "text",
    onClick: toggleKey,
    iconType: state === 'VISIBLE' ? 'eyeClosed' : 'eye',
    "data-test-subj": "showHideTokenButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 11
    }
  }))));
};
exports.ApiKeyField = ApiKeyField;