"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdvancedAgentAuthenticationSettings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _constants = require("../../applications/fleet/constants");
var _hooks = require("../../applications/fleet/hooks");
var _loading = require("../loading");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/components/agent_enrollment_flyout/advanced_agent_authentication_settings.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const NoEnrollmentKeysCallout = ({
  agentPolicyId,
  onCreateEnrollmentApiKey
}) => {
  const {
    notifications
  } = (0, _hooks.useStartServices)();
  const [isLoadingEnrollmentKey, setIsLoadingEnrollmentKey] = (0, _react.useState)(false);
  const onCreateEnrollmentTokenClick = async () => {
    setIsLoadingEnrollmentKey(true);
    if (agentPolicyId) {
      try {
        var _res$data;
        const res = await (0, _hooks.sendCreateEnrollmentAPIKey)({
          policy_id: agentPolicyId
        });
        if (res.error) {
          throw res.error;
        }
        setIsLoadingEnrollmentKey(false);
        if (!((_res$data = res.data) !== null && _res$data !== void 0 && _res$data.item)) {
          return;
        }
        onCreateEnrollmentApiKey(res.data.item);
        notifications.toasts.addSuccess(_i18n.i18n.translate('xpack.fleet.newEnrollmentKey.keyCreatedToasts', {
          defaultMessage: 'Enrollment token created'
        }));
      } catch (error) {
        setIsLoadingEnrollmentKey(false);
        notifications.toasts.addError(error, {
          title: 'Error'
        });
      }
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    title: _i18n.i18n.translate('xpack.fleet.enrollmentStepAgentPolicy.noEnrollmentTokensForSelectedPolicyCallout', {
      defaultMessage: 'There are no enrollment tokens for the selected agent policy'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "eui-textBreakWord",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentEnrenrollmentStepAgentPolicyollment.noEnrollmentTokensForSelectedPolicyCalloutDescription",
    defaultMessage: "You must create and enrollment token in order to enroll agents with this policy",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "plusInCircle",
    isLoading: isLoadingEnrollmentKey,
    fill: true,
    onClick: onCreateEnrollmentTokenClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.enrollmentStepAgentPolicy.setUpAgentsLink",
    defaultMessage: "Create enrollment token",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 9
    }
  })));
};
const AdvancedAgentAuthenticationSettings = ({
  agentPolicyId,
  selectedApiKeyId,
  initialAuthenticationSettingsOpen = false,
  onKeyChange
}) => {
  const {
    notifications
  } = (0, _hooks.useStartServices)();
  const [enrollmentAPIKeys, setEnrollmentAPIKeys] = (0, _react.useState)([]);
  const [isAuthenticationSettingsOpen, setIsAuthenticationSettingsOpen] = (0, _react.useState)(initialAuthenticationSettingsOpen);
  (0, _react.useEffect)(() => {
    setIsAuthenticationSettingsOpen(initialAuthenticationSettingsOpen);
  }, [initialAuthenticationSettingsOpen]);
  const [isLoadingEnrollmentApiKeys, setIsLoadingEnrollmentApiKeys] = (0, _react.useState)(false);
  const onCreateEnrollmentApiKey = (0, _react.useCallback)(key => {
    setEnrollmentAPIKeys([key]);
    onKeyChange(key.id);
  }, [onKeyChange]);
  (0, _react.useEffect)(function useEnrollmentKeysForAgentPolicyEffect() {
    if (!agentPolicyId) {
      setIsAuthenticationSettingsOpen(true);
      setEnrollmentAPIKeys([]);
      return;
    }
    async function fetchEnrollmentAPIKeys() {
      try {
        var _enrollmentAPIKeysRes;
        setIsLoadingEnrollmentApiKeys(true);
        const res = await (0, _hooks.sendGetEnrollmentAPIKeys)({
          page: 1,
          perPage: _constants.SO_SEARCH_LIMIT
        });
        if (res.error) {
          throw res.error;
        }
        if (!res.data) {
          throw new Error('No data while fetching enrollment API keys');
        }
        const enrollmentAPIKeysResponse = res.data.items.filter(key => key.policy_id === agentPolicyId && key.active === true);
        setEnrollmentAPIKeys(enrollmentAPIKeysResponse);
        // Default to the first enrollment key if there is one.
        onKeyChange((_enrollmentAPIKeysRes = enrollmentAPIKeysResponse[0]) === null || _enrollmentAPIKeysRes === void 0 ? void 0 : _enrollmentAPIKeysRes.id);
      } catch (error) {
        notifications.toasts.addError(error, {
          title: 'Error'
        });
      } finally {
        setIsLoadingEnrollmentApiKeys(false);
      }
    }
    fetchEnrollmentAPIKeys();
  }, [onKeyChange, agentPolicyId, notifications.toasts]);
  (0, _react.useEffect)(function useDefaultEnrollmentKeyForAgentPolicyEffect() {
    if (!selectedApiKeyId && enrollmentAPIKeys.length > 0 && enrollmentAPIKeys[0].policy_id === agentPolicyId) {
      const enrollmentAPIKeyId = enrollmentAPIKeys[0].id;
      onKeyChange(enrollmentAPIKeyId);
    }
  }, [enrollmentAPIKeys, selectedApiKeyId, agentPolicyId, onKeyChange]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconSide: "left",
    iconType: isAuthenticationSettingsOpen ? 'arrowDown' : 'arrowRight',
    onClick: () => setIsAuthenticationSettingsOpen(!isAuthenticationSettingsOpen),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.enrollmentStepAgentPolicy.showAuthenticationSettingsButton",
    defaultMessage: "Authentication settings",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 9
    }
  })), isAuthenticationSettingsOpen && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 11
    }
  }), enrollmentAPIKeys.length && selectedApiKeyId ? /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    fullWidth: true,
    options: enrollmentAPIKeys.map(key => ({
      value: key.id,
      text: key.name
    })),
    value: selectedApiKeyId || undefined,
    prepend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 208,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.enrollmentStepAgentPolicy.enrollmentTokenSelectLabel",
      defaultMessage: "Enrollment token",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 209,
        columnNumber: 19
      }
    })),
    "aria-label": _i18n.i18n.translate('xpack.fleet.enrollmentStepAgentPolicy.enrollmentTokenSelectLabel', {
      defaultMessage: 'Enrollment token'
    }),
    onChange: e => {
      onKeyChange(e.target.value);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 13
    }
  }) : isLoadingEnrollmentApiKeys ? /*#__PURE__*/_react.default.createElement(_loading.Loading, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 13
    }
  }) : agentPolicyId ? /*#__PURE__*/_react.default.createElement(NoEnrollmentKeysCallout, {
    agentPolicyId: agentPolicyId,
    onCreateEnrollmentApiKey: onCreateEnrollmentApiKey,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 13
    }
  }) : null));
};
exports.AdvancedAgentAuthenticationSettings = AdvancedAgentAuthenticationSettings;