"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Tags = void 0;
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _utils = require("../agent_list_page/utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agents/components/tags.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const Wrapped = _styledComponents.default.div`
  display: flex;
  .wrappedText {
    white-space: pre-wrap;
  }
`;
// Number of tags displayed before "+ N more" is displayed
const MAX_TAGS_TO_DISPLAY = 3;
const Tags = ({
  tags,
  color,
  size
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(Wrapped, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    anchorClassName: 'wrappedText',
    content: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "agentTagsTooltip",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 37,
        columnNumber: 20
      }
    }, tags.join(', ')),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: size,
    color: color,
    tabIndex: 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "agentTags",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 13
    }
  }, (0, _lodash.take)(tags, 3).map(_utils.truncateTag).join(', '), tags.length > MAX_TAGS_TO_DISPLAY ? ` + ${tags.length - MAX_TAGS_TO_DISPLAY} more` : '')))));
};
exports.Tags = Tags;