"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentRequestDiagnosticsModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _types = require("../../../../../../../common/types");
var _hooks = require("../../../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agents/components/agent_request_diagnostics_modal/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AgentRequestDiagnosticsModal = ({
  onClose,
  agents,
  agentCount
}) => {
  const confirmModalTitleId = (0, _eui.useGeneratedHtmlId)();
  const {
    notifications
  } = (0, _hooks.useStartServices)();
  const [isSubmitting, setIsSubmitting] = (0, _react.useState)(false);
  const isSingleAgent = Array.isArray(agents) && agents.length === 1;
  const {
    getPath
  } = (0, _hooks.useLink)();
  const history = (0, _reactRouterDom.useHistory)();
  const [cpuMetricsEnabled, setCPUMetricsEnabled] = (0, _react.useState)(false);
  async function onSubmit() {
    try {
      setIsSubmitting(true);
      const additionalMetrics = cpuMetricsEnabled ? [_types.RequestDiagnosticsAdditionalMetrics.CPU] : [];
      const {
        error
      } = isSingleAgent ? await (0, _hooks.sendPostRequestDiagnostics)(agents[0].id, {
        additional_metrics: additionalMetrics
      }) : await (0, _hooks.sendPostBulkRequestDiagnostics)({
        agents: typeof agents === 'string' ? agents : agents.map(agent => agent.id),
        additional_metrics: additionalMetrics
      });
      if (error) {
        throw error;
      }
      setIsSubmitting(false);
      const successMessage = _i18n.i18n.translate('xpack.fleet.requestDiagnostics.successSingleNotificationTitle', {
        defaultMessage: 'Request diagnostics submitted'
      });
      notifications.toasts.addSuccess(successMessage);
      if (isSingleAgent) {
        const path = getPath('agent_details_diagnostics', {
          agentId: agents[0].id
        });
        history.push(path);
      }
      onClose();
    } catch (error) {
      setIsSubmitting(false);
      notifications.toasts.addError(error, {
        title: _i18n.i18n.translate('xpack.fleet.requestDiagnostics.fatalErrorNotificationTitle', {
          defaultMessage: 'Error requesting diagnostics {count, plural, one {agent} other {agents}}',
          values: {
            count: agentCount
          }
        })
      });
    }
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "data-test-subj": "requestDiagnosticsModal",
    "aria-labelledby": confirmModalTitleId,
    title: isSingleAgent ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.requestDiagnostics.singleTitle",
      defaultMessage: "Request diagnostics",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 11
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.requestDiagnostics.multipleTitle",
      defaultMessage: "Request diagnostics for {count} agents",
      values: {
        count: agentCount
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 11
      }
    }),
    titleProps: {
      id: confirmModalTitleId
    },
    onCancel: onClose,
    onConfirm: onSubmit,
    cancelButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.requestDiagnostics.cancelButtonLabel",
      defaultMessage: "Cancel",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 9
      }
    }),
    confirmButtonDisabled: isSubmitting,
    confirmButtonText: isSingleAgent ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.requestDiagnostics.confirmSingleButtonLabel",
      defaultMessage: "Request diagnostics",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 11
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.requestDiagnostics.confirmMultipleButtonLabel",
      defaultMessage: "Request diagnostics for {count} agents",
      values: {
        count: agentCount
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 11
      }
    }),
    buttonColor: "primary",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.requestDiagnostics.description",
    defaultMessage: "Consider changing the log level to debug before requesting a diagnostic. Diagnostics files are stored in Elasticsearch, and as such can incur storage costs. By default, files are deleted periodically through an ILM policy.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: "cpuMetricsCheckbox",
    "data-test-subj": "cpuMetricsCheckbox",
    label: "Collect additional CPU metrics",
    checked: cpuMetricsEnabled,
    onChange: () => setCPUMetricsEnabled(!cpuMetricsEnabled),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 9
    }
  })));
};
exports.AgentRequestDiagnosticsModal = AgentRequestDiagnosticsModal;