"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SecretFormRow = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _secrets = require("../../../../../../../../common/constants/secrets");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agents/agent_list_page/components/change_agent_privilege_level_flyout/action_secret_form_row.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SecretFormRow = ({
  children,
  fullWidth,
  useSecretsStorage,
  secretLabelTitle,
  plainTextLabel,
  additionalHelpText
}) => {
  const secretLabel = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "lock",
    "data-test-subj": "lockIcon",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 7
    }
  }), "\xA0", secretLabelTitle, "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: _i18n.i18n.translate('xpack.fleet.agentList.changeAgentPrivilegeLevelFlyout.secretFormRow.secretLabelTooltip', {
      defaultMessage: 'This value will be stored as a secret.'
    }),
    type: "question",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 7
    }
  }));
  const secretHelpText = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.changeAgentPrivilegeLevelFlyout.secretFormRow.secretHelpText",
    defaultMessage: "{description}{br}This field uses secret storage and requires Fleet Server v{minVersion} or higher.",
    values: {
      description: additionalHelpText,
      br: /*#__PURE__*/_react.default.createElement("br", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 54,
          columnNumber: 13
        }
      }),
      minVersion: _secrets.ACTION_SECRETS_MINIMUM_FLEET_SERVER_VERSION
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 5
    }
  });
  const plainHelpText = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.changeAgentPrivilegeLevelFlyout.secretFormRow.plainHelpText",
    defaultMessage: "{description}{br}Upgrade Fleet Server to v{minVersion} or higher to store this field as a secret.",
    values: {
      description: additionalHelpText,
      br: /*#__PURE__*/_react.default.createElement("br", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 66,
          columnNumber: 13
        }
      }),
      minVersion: _secrets.ACTION_SECRETS_MINIMUM_FLEET_SERVER_VERSION
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 5
    }
  });
  const label = useSecretsStorage ? secretLabel : plainTextLabel;
  const helpText = useSecretsStorage ? secretHelpText : plainHelpText;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: fullWidth,
    label: label,
    helpText: helpText,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 5
    }
  }, children);
};
exports.SecretFormRow = SecretFormRow;