"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentActivityButton = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agents/agent_list_page/components/agent_activity_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AgentActivityButton = ({
  onClickAgentActivity,
  shouldShowTour = false
}) => {
  const {
    isOpen,
    dismiss
  } = (0, _hooks.useDismissableTour)('AGENT_ACTIVITY', shouldShowTour);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTourStep, {
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 24,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentActivityButton.tourContent",
      defaultMessage: "Review in progress, completed, and scheduled agent action activity history here anytime.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 25,
        columnNumber: 13
      }
    })),
    isStepOpen: isOpen,
    onFinish: dismiss,
    minWidth: 360,
    maxWidth: 360,
    step: 1,
    stepsTotal: 1,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentActivityButton.tourTitle",
      defaultMessage: "Agent activity history",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 38,
        columnNumber: 11
      }
    }),
    anchorPosition: "upCenter",
    footerAction: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: dismiss,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 45,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.genericTourPopover.dismissButton",
      defaultMessage: "Got it",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 13
      }
    })),
    anchor: "#agentActivityButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 22,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => {
      onClickAgentActivity();
    },
    "data-test-subj": "agentActivityButton",
    iconType: "clock",
    id: "agentActivityButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.agentActivityButton",
    defaultMessage: "Agent activity",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 9
    }
  })));
};
exports.AgentActivityButton = AgentActivityButton;