"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentPolicyListPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _reactRouterDom = require("react-router-dom");
var _services = require("../../../../../../common/services");
var _constants = require("../../../constants");
var _hooks = require("../../../hooks");
var _components = require("../../../components");
var _components2 = require("../../../../../components");
var _components3 = require("../components");
var _components4 = require("./components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agent_policy/list_page/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AgentPolicyListPage = () => {
  var _urlParams$kuery, _agentPolicyData$tota;
  (0, _hooks.useBreadcrumbs)('policies_list');
  const {
    getPath
  } = (0, _hooks.useLink)();
  const hasFleetAllAgentPoliciesPrivileges = (0, _hooks.useAuthz)().fleet.allAgentPolicies;
  const agentPolicySavedObjectType = _constants.LEGACY_AGENT_POLICY_SAVED_OBJECT_TYPE;
  const {
    agents: {
      enabled: isFleetEnabled
    }
  } = (0, _hooks.useConfig)();

  // Table and search states
  const {
    urlParams,
    toUrlParams
  } = (0, _hooks.useUrlParams)();
  const {
    showAgentless
  } = (0, _hooks.useAgentlessResources)();
  const [search, setSearch] = (0, _react.useState)(Array.isArray(urlParams.kuery) ? urlParams.kuery[urlParams.kuery.length - 1] : (_urlParams$kuery = urlParams.kuery) !== null && _urlParams$kuery !== void 0 ? _urlParams$kuery : '');
  const {
    pagination,
    pageSizeOptions,
    setPagination
  } = (0, _hooks.usePagination)();
  const {
    sorting,
    setSorting
  } = (0, _hooks.useSorting)({
    field: 'updated_at',
    direction: 'desc'
  });
  const history = (0, _reactRouterDom.useHistory)();
  const isCreateAgentPolicyFlyoutOpen = 'create' in urlParams;
  const setIsCreateAgentPolicyFlyoutOpen = (0, _react.useCallback)(isOpen => {
    if (isOpen !== isCreateAgentPolicyFlyoutOpen) {
      if (isOpen) {
        history.push(`${getPath('policies_list')}?${toUrlParams({
          ...urlParams,
          create: null
        })}`);
      } else {
        const {
          create,
          ...params
        } = urlParams;
        history.push(`${getPath('policies_list')}?${toUrlParams(params)}`);
      }
    }
  }, [getPath, history, isCreateAgentPolicyFlyoutOpen, toUrlParams, urlParams]);

  // Hide agentless policies by default unless showAgentless toggle is enabled
  const getSearchWithDefaults = newSearch => {
    if (showAgentless) {
      return newSearch;
    }
    const defaultSearch = `NOT ${agentPolicySavedObjectType}.supports_agentless:true`;
    return newSearch.trim() ? `(${defaultSearch}) AND (${newSearch})` : defaultSearch;
  };

  // Fetch agent policies
  const {
    isLoading,
    data: agentPolicyData,
    refetch: resendRequest
  } = (0, _hooks.useGetAgentPoliciesQuery)({
    page: pagination.currentPage,
    perPage: pagination.pageSize,
    sortField: sorting === null || sorting === void 0 ? void 0 : sorting.field,
    sortOrder: sorting === null || sorting === void 0 ? void 0 : sorting.direction,
    kuery: getSearchWithDefaults(search),
    withAgentCount: true,
    // Explicitly fetch agent count
    full: true
  });

  // Some policies retrieved, set up table props
  const columns = (0, _react.useMemo)(() => {
    const cols = [{
      field: 'name',
      sortable: true,
      name: _i18n.i18n.translate('xpack.fleet.agentPolicyList.nameColumnTitle', {
        defaultMessage: 'Name'
      }),
      width: '35%',
      render: (name, agentPolicy) => /*#__PURE__*/_react.default.createElement(_components2.AgentPolicySummaryLine, {
        policy: agentPolicy,
        withDescription: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 126,
          columnNumber: 11
        }
      })
    }, {
      field: 'updated_at',
      sortable: true,
      name: _i18n.i18n.translate('xpack.fleet.agentPolicyList.updatedOnColumnTitle', {
        defaultMessage: 'Last updated on'
      }),
      render: date => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedDate, {
        value: date,
        year: "numeric",
        month: "short",
        day: "2-digit",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 136,
          columnNumber: 11
        }
      })
    }, {
      field: 'agents',
      name: _i18n.i18n.translate('xpack.fleet.agentPolicyList.agentsColumnTitle', {
        defaultMessage: 'Unprivileged / Privileged'
      }),
      dataType: 'number',
      render: (agents, agentPolicy) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: "row",
        gutterSize: "xs",
        justifyContent: "flexEnd",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 146,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 147,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.agentPolicyList.agentsColumn.unprivilegedAgentsTooltip",
          defaultMessage: "Unprivileged agents",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 150,
            columnNumber: 19
          }
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 148,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_components3.LinkedAgentCount, {
        count: agentPolicy.unprivileged_agents || 0,
        agentPolicyId: agentPolicy.id,
        showAgentText: false,
        privilegeMode: "unprivileged",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 156,
          columnNumber: 17
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 164,
          columnNumber: 13
        }
      }, "/"), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 165,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.agentPolicyList.agentsColumn.privilegedAgentsTooltip",
          defaultMessage: "Privileged agents",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 168,
            columnNumber: 19
          }
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 166,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_components3.LinkedAgentCount, {
        count: agents - (agentPolicy.unprivileged_agents || 0),
        agentPolicyId: agentPolicy.id,
        showAgentText: false,
        privilegeMode: "privileged",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 174,
          columnNumber: 17
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 182,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement("span", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 183,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentPolicyList.agentsColumn.totalAgentsTooltipWrapper",
        defaultMessage: "({message})",
        values: {
          message: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
            content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "xpack.fleet.agentPolicyList.agentsColumn.totalAgentsTooltip",
              defaultMessage: "Total agents",
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 191,
                columnNumber: 27
              }
            }),
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 189,
              columnNumber: 23
            }
          }, /*#__PURE__*/_react.default.createElement(_components3.LinkedAgentCount, {
            count: agents,
            agentPolicyId: agentPolicy.id,
            showAgentText: false,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 197,
              columnNumber: 25
            }
          }))
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 184,
          columnNumber: 17
        }
      }))), (0, _services.getRootIntegrations)(agentPolicy.package_policies || []).length > 0 && (agentPolicy.unprivileged_agents || 0) > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 210,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        type: "warning",
        color: "warning",
        content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.agentPolicyList.agentsColumn.containsUnprivilegedAgentsWarning",
          defaultMessage: "This agent policy contains integrations that require Elastic Agents to have root privileges. Some enrolled agents are running in unprivileged mode.",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 215,
            columnNumber: 23
          }
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 211,
          columnNumber: 19
        }
      })))
    }, {
      field: 'package_policies',
      name: _i18n.i18n.translate('xpack.fleet.agentPolicyList.packagePoliciesCountColumnTitle', {
        defaultMessage: 'Integrations'
      }),
      dataType: 'number',
      render: packagePolicies => packagePolicies ? packagePolicies.length : 0
    }, {
      field: 'actions',
      name: _i18n.i18n.translate('xpack.fleet.agentPolicyList.actionsColumnTitle', {
        defaultMessage: 'Actions'
      }),
      actions: [{
        render: agentPolicy => /*#__PURE__*/_react.default.createElement(_components3.AgentPolicyActionMenu, {
          agentPolicy: agentPolicy,
          onCopySuccess: () => resendRequest(),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 243,
            columnNumber: 15
          }
        })
      }]
    }];

    // If Fleet is not enabled, then remove the `agents` column
    if (!isFleetEnabled) {
      return cols.filter(col => 'field' in col ? col.field !== 'agents' : true);
    }
    return cols;
  }, [isFleetEnabled, resendRequest]);
  const createAgentPolicyButton = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    iconType: "plusInCircle",
    isDisabled: !hasFleetAllAgentPoliciesPrivileges,
    onClick: () => setIsCreateAgentPolicyFlyoutOpen(true),
    "data-test-subj": "createAgentPolicyButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 263,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentPolicyList.addButton",
    defaultMessage: "Create agent policy",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 270,
      columnNumber: 9
    }
  })), [hasFleetAllAgentPoliciesPrivileges, setIsCreateAgentPolicyFlyoutOpen]);
  const emptyStateCreateAgentPolicyButton = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    iconType: "plusInCircle",
    isDisabled: !hasFleetAllAgentPoliciesPrivileges,
    onClick: () => setIsCreateAgentPolicyFlyoutOpen(true),
    "data-test-subj": "emptyPromptCreateAgentPolicyButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 281,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentPolicyList.addButton",
    defaultMessage: "Create agent policy",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 288,
      columnNumber: 9
    }
  })), [hasFleetAllAgentPoliciesPrivileges, setIsCreateAgentPolicyFlyoutOpen]);
  const emptyPrompt = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 301,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyList.noAgentPoliciesPrompt",
      defaultMessage: "No agent policies",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 302,
        columnNumber: 13
      }
    })),
    actions: emptyStateCreateAgentPolicyButton,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 299,
      columnNumber: 7
    }
  }), [emptyStateCreateAgentPolicyButton]);
  const onTableChange = criteria => {
    const newPagination = {
      ...pagination,
      currentPage: criteria.page.index + 1,
      pageSize: criteria.page.size
    };
    setPagination(newPagination);
    setSorting(criteria.sort);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isCreateAgentPolicyFlyoutOpen ? /*#__PURE__*/_react.default.createElement(_components4.CreateAgentPolicyFlyout, {
    onClose: () => {
      setIsCreateAgentPolicyFlyoutOpen(false);
      resendRequest();
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 327,
      columnNumber: 9
    }
  }) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: 'center',
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 334,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 4,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 335,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_components.SearchBar, {
    value: search,
    indexPattern: _constants.INGEST_SAVED_OBJECT_INDEX,
    fieldPrefix: agentPolicySavedObjectType,
    onChange: newSearch => {
      setPagination({
        ...pagination,
        currentPage: 1
      });
      setSearch(newSearch);
    },
    dataTestSubj: "agentPolicyList.queryInput",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 336,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 350,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    iconType: "refresh",
    onClick: () => resendRequest(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 351,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentPolicyList.reloadAgentPoliciesButtonText",
    defaultMessage: "Reload",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 352,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 358,
      columnNumber: 9
    }
  }, createAgentPolicyButton)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 360,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    loading: isLoading,
    "data-test-subj": "agentPoliciesTable",
    noItemsMessage: isLoading ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyList.loadingAgentPoliciesMessage",
      defaultMessage: "Loading agent policies\u2026",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 366,
        columnNumber: 13
      }
    }) : !search.trim() && ((_agentPolicyData$tota = agentPolicyData === null || agentPolicyData === void 0 ? void 0 : agentPolicyData.total) !== null && _agentPolicyData$tota !== void 0 ? _agentPolicyData$tota : 0) === 0 ? emptyPrompt : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyList.noFilteredAgentPoliciesPrompt",
      defaultMessage: "No agent policies found. {clearFiltersLink}",
      values: {
        clearFiltersLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          onClick: () => setSearch(''),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 378,
            columnNumber: 19
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.agentPolicyList.clearFiltersLinkText",
          defaultMessage: "Clear filters",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 379,
            columnNumber: 21
          }
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 373,
        columnNumber: 13
      }
    }),
    items: agentPolicyData ? agentPolicyData.items : [],
    itemId: "id",
    columns: columns,
    pagination: {
      pageIndex: pagination.currentPage - 1,
      pageSize: pagination.pageSize,
      totalItemCount: agentPolicyData ? agentPolicyData.total : 0,
      pageSizeOptions
    },
    sorting: {
      sort: sorting
    },
    onChange: onTableChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 361,
      columnNumber: 7
    }
  }));
};
exports.AgentPolicyListPage = AgentPolicyListPage;