"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GeoUploadForm = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/data-plugin/public");
var _codeEditor = require("@kbn/code-editor");
var _geo_file_picker = require("./geo_file_picker");
var _index_name_form = require("./index_name_form");
var _validate_index_name = require("../../validate_index_name");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/file_upload/public/components/geo_upload_form/geo_upload_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const GEO_FIELD_TYPE_OPTIONS = [{
  text: _public.ES_FIELD_TYPES.GEO_POINT,
  value: _public.ES_FIELD_TYPES.GEO_POINT
}, {
  text: _public.ES_FIELD_TYPES.GEO_SHAPE,
  value: _public.ES_FIELD_TYPES.GEO_SHAPE
}];
class GeoUploadForm extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "state", {
      hasFile: false,
      isPointsOnly: false
    });
    (0, _defineProperty2.default)(this, "_onFileSelect", async onFileSelectParameters => {
      this.setState({
        hasFile: true,
        isPointsOnly: onFileSelectParameters.hasPoints && !onFileSelectParameters.hasShapes
      });
      this.props.onFileSelect(onFileSelectParameters);
      this.props.onIndexNameValidationStart();
      const indexNameError = await (0, _validate_index_name.validateIndexName)(onFileSelectParameters.indexName);
      if (!this._isMounted) {
        return;
      }
      this.props.onIndexNameValidationEnd();
      this.props.onIndexNameChange(onFileSelectParameters.indexName, indexNameError);
      const geoFieldType = onFileSelectParameters.hasPoints && !onFileSelectParameters.hasShapes ? _public.ES_FIELD_TYPES.GEO_POINT : _public.ES_FIELD_TYPES.GEO_SHAPE;
      this.props.onGeoFieldTypeSelect(geoFieldType);
    });
    (0, _defineProperty2.default)(this, "_onFileClear", () => {
      this.setState({
        hasFile: false,
        isPointsOnly: false
      });
      this.props.onFileClear();
      this.props.onIndexNameChange('');
    });
    (0, _defineProperty2.default)(this, "_onGeoFieldTypeSelect", event => {
      return this.props.onGeoFieldTypeSelect(event.target.value);
    });
    (0, _defineProperty2.default)(this, "_onSmallChunksChange", event => {
      this.props.onSmallChunksChange(event.target.checked);
    });
  }
  componentDidMount() {
    this._isMounted = true;
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  _renderGeoFieldTypeSelect() {
    return this.state.hasFile && this.state.isPointsOnly ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.fileUpload.indexSettings.enterIndexTypeLabel', {
        defaultMessage: 'Index type'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 121,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      "data-test-subj": "fileImportIndexSelect",
      options: GEO_FIELD_TYPE_OPTIONS,
      value: this.props.geoFieldType,
      onChange: this._onGeoFieldTypeSelect,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 126,
        columnNumber: 9
      }
    })) : null;
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 138,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_geo_file_picker.GeoFilePicker, {
      onSelect: this._onFileSelect,
      onClear: this._onFileClear,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 9
      }
    }), this._renderGeoFieldTypeSelect(), this.state.hasFile ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_index_name_form.IndexNameForm, {
      indexName: this.props.indexName,
      indexNameError: this.props.indexNameError,
      onIndexNameChange: this.props.onIndexNameChange,
      onIndexNameValidationStart: this.props.onIndexNameValidationStart,
      onIndexNameValidationEnd: this.props.onIndexNameValidationEnd,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 150,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
      id: "advancedAccordion",
      buttonContent: _i18n.i18n.translate('xpack.fileUpload.geo.advancedAccordionLabel', {
        defaultMessage: 'Advanced'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 151,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 157,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      display: "columnCompressed",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 158,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: _i18n.i18n.translate('xpack.fileUpload.smallChunks.tooltip', {
        defaultMessage: 'Use to alleviate request timeout failures.'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 159,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      label: _i18n.i18n.translate('xpack.fileUpload.smallChunks.switchLabel', {
        defaultMessage: 'Upload file in smaller chunks'
      }),
      checked: this.props.smallChunks,
      onChange: this._onSmallChunksChange,
      compressed: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 165,
        columnNumber: 19
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 175,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.fileUpload.geo.indexSettingsLabel', {
        defaultMessage: 'Index settings'
      }),
      fullWidth: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 176,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
      value: this.props.indexSettings,
      height: "100px",
      languageId: "json",
      languageConfiguration: {
        autoClosingPairs: [{
          open: '{',
          close: '}'
        }]
      },
      options: {
        tabSize: 2,
        automaticLayout: true,
        wordWrap: 'on',
        wrappingIndent: 'indent',
        minimap: {
          enabled: false
        },
        scrollBeyondLastLine: false,
        quickSuggestions: true
      },
      onChange: this.props.onIndexSettingsChange,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 182,
        columnNumber: 17
      }
    })))) : null);
  }
}
exports.GeoUploadForm = GeoUploadForm;