"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createSplitPoint = createSplitPoint;
exports.getXSeriesPoint = exports.getTooltipActions = void 0;
var _chartExpressionsCommon = require("@kbn/chart-expressions-common");
var _i18n = require("@kbn/i18n");
var _esQuery = require("@kbn/es-query");
var _common = require("@kbn/data-plugin/common");
var _helpers = require("../../../common/helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function nonNullable(v) {
  return v != null;
}
function createSplitPoint(accessor, value, rows, table) {
  if (value === undefined) return;
  const splitPointRowIndex = rows.findIndex(row => {
    if (Array.isArray(value)) {
      return value.includes(row[accessor]);
    }
    return row[accessor] === value;
  });
  if (splitPointRowIndex !== -1) {
    return {
      row: splitPointRowIndex,
      column: table.columns.findIndex(column => column.id === accessor),
      value: table.rows[splitPointRowIndex][accessor],
      table
    };
  }
}
const getXSeriesPoint = (layer, value, fieldFormats, formattedDatatables, xAxisFormatter, formatFactory) => {
  var _formattedDatatables$;
  const {
    table
  } = layer;
  const xColumn = layer.xAccessor && (0, _chartExpressionsCommon.getColumnByAccessor)(layer.xAccessor, table.columns);
  const xAccessor = layer.xAccessor ? (0, _chartExpressionsCommon.getAccessorByDimension)(layer.xAccessor, table.columns) : undefined;
  const xFormat = xColumn ? fieldFormats[layer.layerId].xAccessors[xColumn.id] : undefined;
  const currentXFormatter = xAccessor && (_formattedDatatables$ = formattedDatatables[layer.layerId]) !== null && _formattedDatatables$ !== void 0 && _formattedDatatables$.formattedColumns[xAccessor] && xColumn ? formatFactory(xFormat) : xAxisFormatter;
  const rowIndex = table.rows.findIndex(row => {
    if (xAccessor) {
      var _formattedDatatables$2;
      if ((_formattedDatatables$2 = formattedDatatables[layer.layerId]) !== null && _formattedDatatables$2 !== void 0 && _formattedDatatables$2.formattedColumns[xAccessor]) {
        // stringify the value to compare with the chart value
        return currentXFormatter.convert(row[xAccessor]) === value;
      }
      return row[xAccessor] === value;
    }
  });
  return {
    row: rowIndex,
    column: table.columns.findIndex(col => col.id === xAccessor),
    table,
    value: xAccessor ? table.rows[rowIndex][xAccessor] : value
  };
};
exports.getXSeriesPoint = getXSeriesPoint;
function getXSeriesValue(dataLayers, firstSeries) {
  var _firstSeries$datum;
  const layer = dataLayers.find(l => firstSeries.seriesIdentifier.seriesKeys.some(key => l.accessors.some(accessor => (0, _chartExpressionsCommon.getAccessorByDimension)(accessor, l.table.columns) === key.toString())));
  if (!layer) return;
  const {
    table
  } = layer;
  const xAccessor = layer.xAccessor ? (0, _chartExpressionsCommon.getAccessorByDimension)(layer.xAccessor, table.columns) : undefined;
  return xAccessor ? (_firstSeries$datum = firstSeries.datum) === null || _firstSeries$datum === void 0 ? void 0 : _firstSeries$datum[xAccessor] : null;
}
const getTooltipActions = (dataLayers, onClickMultiValue, onCreateAlertRule, fieldFormats, formattedDatatables, xAxisFormatter, formatFactory, isEsqlMode, canCreateAlerts, isEnabled) => {
  if (!isEnabled) return;
  const hasSplitAccessors = dataLayers.some(l => {
    var _l$splitAccessors;
    return (_l$splitAccessors = l.splitAccessors) === null || _l$splitAccessors === void 0 ? void 0 : _l$splitAccessors.length;
  });
  const hasXAxis = dataLayers.every(l => l.xAccessor);
  const isTimeViz = (0, _helpers.isTimeChart)(dataLayers);
  const xSeriesActions = !isEsqlMode && hasXAxis ? [{
    disabled: () => !hasXAxis,
    label: (_, [firstSeries]) => {
      if (isTimeViz) {
        return _i18n.i18n.translate('expressionXY.tooltipActions.filterByTime', {
          defaultMessage: 'Filter by time'
        });
      }
      const value = getXSeriesValue(dataLayers, firstSeries);
      return _i18n.i18n.translate('expressionXY.tooltipActions.filterForXSeries', {
        defaultMessage: 'Filter for {value}',
        values: {
          value: xAxisFormatter.convert(value) || value
        }
      });
    },
    onSelect: (_, [firstSeries]) => {
      const layer = dataLayers.find(l => firstSeries.seriesIdentifier.seriesKeys.some(key => l.accessors.some(accessor => (0, _chartExpressionsCommon.getAccessorByDimension)(accessor, l.table.columns) === key.toString())));
      if (!layer) return;
      const value = getXSeriesValue(dataLayers, firstSeries);
      const xSeriesPoint = getXSeriesPoint(layer, value, fieldFormats, formattedDatatables, xAxisFormatter, formatFactory);
      const context = {
        data: [{
          table: xSeriesPoint.table,
          cells: [{
            row: xSeriesPoint.row,
            column: xSeriesPoint.column
          }]
        }]
      };
      onClickMultiValue(context);
    }
  }] : [];
  const alertRulesTooltipActions = isEsqlMode && canCreateAlerts ? [{
    disabled: () => !isEsqlMode,
    label: () => _i18n.i18n.translate('expressionXY.tooltipActions.addAlertRule', {
      defaultMessage: 'Create alert rule'
    }),
    onSelect: (selectedValues, series) => {
      var _xColumn$meta$sourceP, _xColumn$meta, _xColumn$name, _table$meta;
      const [firstSeries] = series;
      const layer = dataLayers.find(l => firstSeries.seriesIdentifier.seriesKeys.some(key => l.accessors.some(accessor => (0, _chartExpressionsCommon.getAccessorByDimension)(accessor, l.table.columns) === key.toString())));
      if (!layer) return;
      const {
        xAccessor
      } = firstSeries.seriesIdentifier;
      const xSeriesValue = getXSeriesValue(dataLayers, firstSeries);
      const xSeriesPoint = getXSeriesPoint(layer, xSeriesValue, fieldFormats, formattedDatatables, xAxisFormatter, formatFactory);
      const {
        table
      } = xSeriesPoint;
      const xColumn = (0, _chartExpressionsCommon.getColumnByAccessor)(xAccessor.toString(), table.columns);

      // Get the field name and value for the Y axis
      const selectedYValues = selectedValues.length ? selectedValues : [firstSeries];
      const thresholdValues = selectedYValues.map(value => {
        var _yColumn$name;
        const {
          yAccessor,
          splitAccessors
        } = value.seriesIdentifier;
        const yColumn = (0, _chartExpressionsCommon.getColumnByAccessor)(yAccessor.toString(), table.columns);
        if (!yColumn || !yColumn.meta.sourceParams) return null;
        const {
          sourceField
        } = yColumn.meta.sourceParams;
        const yValue = value.value;
        // If there is no sourceField, wrap the Y axis label in {curly braces} to let the user set the field name manually
        const esqlFieldName = String(sourceField !== null && sourceField !== void 0 ? sourceField : `{${(_yColumn$name = yColumn === null || yColumn === void 0 ? void 0 : yColumn.name) !== null && _yColumn$name !== void 0 ? _yColumn$name : 'Y'}}`);
        const values = {
          [esqlFieldName]: yValue
        };
        if (splitAccessors.size > 0) {
          for (const [accessor, splitValue] of splitAccessors) {
            var _splitColumn$meta$sou, _splitColumn$meta;
            const splitColumn = (0, _chartExpressionsCommon.getColumnByAccessor)(accessor.toString(), table.columns);
            const {
              sourceField: splitSourceField
            } = (_splitColumn$meta$sou = splitColumn === null || splitColumn === void 0 ? void 0 : (_splitColumn$meta = splitColumn.meta) === null || _splitColumn$meta === void 0 ? void 0 : _splitColumn$meta.sourceParams) !== null && _splitColumn$meta$sou !== void 0 ? _splitColumn$meta$sou : {};
            if (!splitSourceField) continue;
            values[String(splitSourceField)] = splitValue;
          }
        }
        return {
          values,
          yField: esqlFieldName
        };
      }).filter(Boolean);

      // Get the time field name from the X axis for time vizzes, default to timestamp for non-time vizzes
      const {
        sourceField: xSourceField
      } = (_xColumn$meta$sourceP = xColumn === null || xColumn === void 0 ? void 0 : (_xColumn$meta = xColumn.meta) === null || _xColumn$meta === void 0 ? void 0 : _xColumn$meta.sourceParams) !== null && _xColumn$meta$sourceP !== void 0 ? _xColumn$meta$sourceP : {};

      // For non-time vizzes, report the X axis
      const xValues = isTimeViz || !hasXAxis ? {} : {
        // If there is no sourceField, wrap the X axis label in [brackets] to let the user set the field name manually
        [String(xSourceField !== null && xSourceField !== void 0 ? xSourceField : `[${(_xColumn$name = xColumn === null || xColumn === void 0 ? void 0 : xColumn.name) !== null && _xColumn$name !== void 0 ? _xColumn$name : 'X'}]`)]:
        // Use xSeriesPoint.value instead of xSeriesValue; this is always the raw ES value, xSeriesValue sometimes returns
        // the display value
        xSeriesPoint.value
      };
      const query = ((_table$meta = table.meta) === null || _table$meta === void 0 ? void 0 : _table$meta.type) === _common.ESQL_TABLE_TYPE ? table.meta.query : null;
      const context = {
        thresholdValues,
        xValues,
        query
      };
      onCreateAlertRule(context);
    }
  }] : [];
  const breakdownTooltipActions = !isEsqlMode && hasSplitAccessors ? [{
    disabled: selected => selected.length < 1,
    label: selected => selected.length === 0 ? _i18n.i18n.translate('expressionXY.tooltipActions.emptyFilterSelection', {
      defaultMessage: 'Select at least one series to filter'
    }) : _i18n.i18n.translate('expressionXY.tooltipActions.filterValues', {
      defaultMessage: 'Filter {seriesNumber} selected series',
      values: {
        seriesNumber: selected.length
      }
    }),
    onSelect: tooltipSelectedValues => {
      const layerIndexes = [];
      tooltipSelectedValues.forEach(v => {
        const index = dataLayers.findIndex(l => v.seriesIdentifier.seriesKeys.some(key => l.accessors.some(accessor => (0, _chartExpressionsCommon.getAccessorByDimension)(accessor, l.table.columns) === key.toString())));
        if (!layerIndexes.includes(index) && index !== -1) {
          layerIndexes.push(index);
        }
      });
      const filterPoints = [];
      if (!layerIndexes.length) return;
      layerIndexes.forEach(layerIndex => {
        var _layer$splitAccessors;
        const layer = dataLayers[layerIndex];
        const {
          table
        } = layer;
        if (((_layer$splitAccessors = layer.splitAccessors) === null || _layer$splitAccessors === void 0 ? void 0 : _layer$splitAccessors.length) !== 1) return;
        const splitAccessor = (0, _chartExpressionsCommon.getAccessorByDimension)(layer.splitAccessors[0], table.columns);
        const splitPoints = tooltipSelectedValues.map(v => {
          var _v$datum;
          return createSplitPoint(splitAccessor, (_v$datum = v.datum) === null || _v$datum === void 0 ? void 0 : _v$datum[splitAccessor], formattedDatatables[layer.layerId].table.rows, table);
        }).filter(nonNullable);
        if (splitPoints.length) {
          filterPoints.push({
            cells: splitPoints.map(({
              row,
              column
            }) => ({
              row,
              column
            })),
            relation: _esQuery.BooleanRelation.OR,
            table
          });
        }
      });
      if (filterPoints !== null && filterPoints !== void 0 && filterPoints.length) {
        onClickMultiValue({
          data: filterPoints
        });
      }
    }
  }] : [];
  const actions = [...xSeriesActions, ...breakdownTooltipActions, ...alertRulesTooltipActions];
  if (!actions.length) return;
  return actions;
};
exports.getTooltipActions = getTooltipActions;