"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLayers = void 0;
var _coloring = require("@kbn/coloring");
var _chartExpressionsCommon = require("@kbn/chart-expressions-common");
var _ = require("..");
var _types = require("../../../common/types");
var _sort_predicate = require("./sort_predicate");
var _get_color = require("./get_color");
var _get_node_labels = require("./get_node_labels");
var _color_mapping_accessors = require("../colors/color_mapping_accessors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getLayers = (chartType, columns, visParams, visData, overwriteColors = {}, rows, paletteService, palettes, formatters, formatter, syncColors, isDarkMode) => {
  var _columns$, _columns$2, _columns$3;
  const fillLabel = {
    valueFont: {
      fontWeight: 700
    }
  };
  if (!visParams.labels.values) {
    fillLabel.valueFormatter = () => '';
  }
  const categories = chartType === _types.ChartTypes.MOSAIC && columns.length === 2 ? (0, _chartExpressionsCommon.getColorCategories)(rows, (_columns$ = columns[1]) === null || _columns$ === void 0 ? void 0 : _columns$.id) : (0, _chartExpressionsCommon.getColorCategories)(rows, (_columns$2 = columns[0]) === null || _columns$2 === void 0 ? void 0 : _columns$2.id);
  const colorIndexMap = new Map(categories.map((c, i) => [String(c), i]));
  const isSplitChart = Boolean(visParams.dimensions.splitColumn || visParams.dimensions.splitRow);
  let byDataPalette;
  if (!syncColors && (_columns$3 = columns[1]) !== null && _columns$3 !== void 0 && _columns$3.id && paletteService && visParams.palette) {
    byDataPalette = (0, _get_color.byDataColorPaletteMap)(paletteService === null || paletteService === void 0 ? void 0 : paletteService.get(visParams.palette.name), visParams.palette, colorIndexMap);
  }
  const sortPredicateForType = (0, _sort_predicate.sortPredicateByType)(chartType, visParams, visData, columns);
  const distinctSeries = (0, _.getDistinctSeries)(rows, columns);

  // return a fn only if color mapping is available in visParams
  const getColorFromMappingFn = getColorFromMappingFactory(chartType, columns, rows, palettes, visParams, isDarkMode);
  return columns.map((col, layerIndex) => {
    var _col$meta, _col$meta$sourceParam;
    return {
      groupByRollup: d => col.id ? d[col.id] : col.name,
      showAccessor: d => true,
      nodeLabel: d => (0, _get_node_labels.getNodeLabel)(d, col, formatters, formatter.deserialize),
      fillLabel: layerIndex === 0 && chartType === _types.ChartTypes.MOSAIC ? {
        ...fillLabel,
        minFontSize: 14,
        maxFontSize: 14,
        clipText: true
      } : fillLabel,
      sortPredicate: (_col$meta = col.meta) !== null && _col$meta !== void 0 && (_col$meta$sourceParam = _col$meta.sourceParams) !== null && _col$meta$sourceParam !== void 0 && _col$meta$sourceParam.consolidatedMetricsColumn ? (0, _sort_predicate.sortPredicateSaveSourceOrder)() : sortPredicateForType,
      shape: {
        // this applies color mapping only if visParams.colorMapping is available
        fillColor: getColorFromMappingFn ? (0, _color_mapping_accessors.getPartitionFillColor)(chartType, layerIndex, columns.length, getColorFromMappingFn) : (key, sortIndex, node) => (0, _get_color.getColor)(chartType, key, node, layerIndex, isSplitChart, overwriteColors, distinctSeries, {
          columnsLength: columns.length,
          rowsLength: rows.length
        }, visParams, paletteService, byDataPalette, syncColors, isDarkMode, formatter, col, colorIndexMap)
      }
    };
  });
};

/**
 * If colorMapping is available, returns a function that accept a string or an array of strings (used in case of multi-field-key)
 * and returns a color specified in the provided mapping
 */
exports.getLayers = getLayers;
function getColorFromMappingFactory(chartType, columns, rows, palettes, visParams, isDarkMode) {
  var _dimensions$buckets, _columns$4, _columns$5;
  const {
    colorMapping,
    dimensions
  } = visParams;
  if (!colorMapping) {
    // return undefined, we will use the legacy color mapping instead
    return undefined;
  }
  // if pie/donut/treemap with no buckets use the default color mode
  if ((chartType === _types.ChartTypes.DONUT || chartType === _types.ChartTypes.PIE || chartType === _types.ChartTypes.TREEMAP) && (!dimensions.buckets || ((_dimensions$buckets = dimensions.buckets) === null || _dimensions$buckets === void 0 ? void 0 : _dimensions$buckets.length) === 0)) {
    return undefined;
  }
  // the mosaic configures the main categories in the second column, instead of the first
  // as it happens in all the other partition types.
  // Independently from the bucket aggregation used, the categories will always be casted
  // as string to make it nicely working with a text input field, avoiding a field
  const categories = chartType === _types.ChartTypes.MOSAIC && columns.length === 2 ? (0, _chartExpressionsCommon.getColorCategories)(rows, (_columns$4 = columns[1]) === null || _columns$4 === void 0 ? void 0 : _columns$4.id) : (0, _chartExpressionsCommon.getColorCategories)(rows, (_columns$5 = columns[0]) === null || _columns$5 === void 0 ? void 0 : _columns$5.id);
  return (0, _coloring.getColorFactory)(JSON.parse(colorMapping), palettes, isDarkMode, {
    type: 'categories',
    categories
  });
}