"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LensEmbeddable = LensEmbeddable;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _public = require("@kbn/observability-shared-plugin/public");
var _use_series_storage = require("./hooks/use_series_storage");
var _use_kibana = require("./hooks/use_kibana");
var _use_time_range = require("./hooks/use_time_range");
var _date_range_picker = require("./components/date_range_picker");
var _telemetry = require("./utils/telemetry");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/exploratory_view/public/components/shared/exploratory_view/lens_embeddable.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EXECUTION_CONTEXT = {
  type: 'observability_exploratory_view'
};
function LensEmbeddable(props) {
  const {
    lensAttributes,
    setChartTimeRangeContext
  } = props;
  const {
    services: {
      lens,
      notifications
    }
  } = (0, _use_kibana.useKibana)();
  const LensComponent = lens === null || lens === void 0 ? void 0 : lens.EmbeddableComponent;
  const LensSaveModalComponent = lens === null || lens === void 0 ? void 0 : lens.SaveModalComponent;
  const {
    firstSeries,
    setSeries,
    reportType,
    lastRefresh
  } = (0, _use_series_storage.useSeriesStorage)();
  const [isSaveOpen, setIsSaveOpen] = (0, _react.useState)(false);
  const firstSeriesId = 0;
  const timeRange = (0, _use_time_range.useExpViewTimeRange)();
  const trackEvent = (0, _public.useUiTracker)();
  const onLensLoad = (0, _react.useCallback)(isLoading => {
    var _parseRelativeDate, _parseRelativeDate2;
    const timeLoaded = Date.now();
    setChartTimeRangeContext === null || setChartTimeRangeContext === void 0 ? void 0 : setChartTimeRangeContext({
      lastUpdated: timeLoaded,
      to: (_parseRelativeDate = (0, _date_range_picker.parseRelativeDate)((timeRange === null || timeRange === void 0 ? void 0 : timeRange.to) || '')) === null || _parseRelativeDate === void 0 ? void 0 : _parseRelativeDate.valueOf(),
      from: (_parseRelativeDate2 = (0, _date_range_picker.parseRelativeDate)((timeRange === null || timeRange === void 0 ? void 0 : timeRange.from) || '')) === null || _parseRelativeDate2 === void 0 ? void 0 : _parseRelativeDate2.valueOf()
    });
    if (!isLoading) {
      (0, _telemetry.trackTelemetryOnLoad)(trackEvent, lastRefresh, timeLoaded);
    }
  }, [setChartTimeRangeContext, timeRange, lastRefresh, trackEvent]);
  const onBrushEnd = (0, _react.useCallback)(({
    range
  }) => {
    if (reportType !== 'data-distribution' && firstSeries) {
      setSeries(firstSeriesId, {
        ...firstSeries,
        time: {
          from: new Date(range[0]).toISOString(),
          to: new Date(range[1]).toISOString()
        }
      });
    } else {
      notifications === null || notifications === void 0 ? void 0 : notifications.toasts.add(_i18n.i18n.translate('xpack.exploratoryView.noBrushing', {
        defaultMessage: 'Zoom by brush selection is only available on time series charts.'
      }));
    }
  }, [reportType, setSeries, firstSeries, notifications === null || notifications === void 0 ? void 0 : notifications.toasts]);
  if (!timeRange || !lensAttributes) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(LensWrapper, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(LensComponent, {
    id: "exploratoryView",
    timeRange: timeRange,
    attributes: lensAttributes,
    onLoad: onLensLoad,
    onBrushEnd: onBrushEnd,
    executionContext: EXECUTION_CONTEXT,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 7
    }
  }), isSaveOpen && lensAttributes && /*#__PURE__*/_react.default.createElement(LensSaveModalComponent, {
    initialInput: lensAttributes,
    onClose: () => setIsSaveOpen(false)
    // if we want to do anything after the viz is saved
    // right now there is no action, so an empty function
    ,
    onSave: () => {},
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 9
    }
  }));
}
const LensWrapper = _styled.default.div`
  height: 100%;

  .embPanel__optionsMenuPopover {
    visibility: collapse;
  }

  &&&:hover {
    .embPanel__optionsMenuPopover {
      visibility: visible;
    }
  }

  && .embPanel--editing {
    border-style: initial !important;
    :hover {
      box-shadow: none;
    }
  }
  .embPanel__title {
    display: none;
  }

  &&& > div {
    height: 100%;
  }
`;