"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.metadataSuggestion = exports.getMetadataSuggestions = exports.METADATA_FIELDS = void 0;
var _i18n = require("@kbn/i18n");
var _helpers = require("../../../definitions/utils/autocomplete/helpers");
var _functions = require("../../../definitions/utils/functions");
var _complete_items = require("../../complete_items");
var _is = require("../../../ast/is");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const METADATA_FIELDS = exports.METADATA_FIELDS = ['_version', '_id', '_index', '_source', '_ignored', '_index_mode', '_score'];
const metadataSuggestion = exports.metadataSuggestion = (0, _helpers.withAutoSuggest)({
  label: 'METADATA',
  text: 'METADATA ',
  kind: 'Reference',
  detail: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.metadataDoc', {
    defaultMessage: 'Metadata'
  }),
  sortText: 'C'
});
const getMetadataSuggestions = (command, queryText) => {
  const metadataNode = command.args.find(arg => (0, _is.isOptionNode)(arg) && arg.name === 'metadata');

  // FROM index METADATA ... /
  if (metadataNode) {
    return suggestForMetadata(metadataNode, queryText);
  }
};
exports.getMetadataSuggestions = getMetadataSuggestions;
async function suggestForMetadata(metadata, innerText) {
  const existingFields = new Set(metadata.args.filter(_is.isColumn).map(({
    name
  }) => name));
  const filteredMetaFields = METADATA_FIELDS.filter(name => !existingFields.has(name));
  const suggestions = [];

  // FROM something METADATA /
  // FROM something METADATA field/
  // FROM something METADATA field, /
  if (/(?:,|METADATA)\s+$/i.test(innerText) || /\S$/.test(innerText)) {
    suggestions.push(...(await (0, _helpers.handleFragment)(innerText, fragment => METADATA_FIELDS.includes(fragment), (_fragment, rangeToReplace) => (0, _functions.buildFieldsDefinitions)(filteredMetaFields).map(suggestion => ({
      ...suggestion,
      rangeToReplace
    })), (fragment, rangeToReplace) => {
      const _suggestions = [(0, _helpers.withAutoSuggest)({
        ..._complete_items.pipeCompleteItem,
        text: fragment + ' | ',
        filterText: fragment,
        rangeToReplace
      })];
      if (filteredMetaFields.length > 1) {
        _suggestions.push((0, _helpers.withAutoSuggest)({
          ..._complete_items.commaCompleteItem,
          text: fragment + ', ',
          filterText: fragment,
          rangeToReplace
        }));
      }
      return _suggestions;
    })));
  } else {
    // METADATA field /
    if (existingFields.size > 0) {
      if (filteredMetaFields.length > 0) {
        suggestions.push(_complete_items.commaCompleteItem);
      }
      suggestions.push(_complete_items.pipeCompleteItem);
    }
  }
  return suggestions;
}