"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.limitCommand = void 0;
var _i18n = require("@kbn/i18n");
var _autocomplete = require("./autocomplete");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const limitCommandMethods = {
  autocomplete: _autocomplete.autocomplete
};
const limitCommand = exports.limitCommand = {
  name: 'limit',
  methods: limitCommandMethods,
  metadata: {
    description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.limitDoc', {
      defaultMessage: 'Returns the first search results, in search order, based on the "limit" specified.'
    }),
    declaration: 'LIMIT max_number_of_rows',
    examples: ['… | LIMIT 100', '… | LIMIT 1']
  }
};