"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IngestPipelinesCard = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _fetch_custom_pipeline_api_logic = require("../../../../api/index/fetch_custom_pipeline_api_logic");
var _index_view_logic = require("../../index_view_logic");
var _pipelines_logic = require("../pipelines_logic");
var _custom_pipeline_item = require("./custom_pipeline_item");
var _default_pipeline_item = require("./default_pipeline_item");
var _ingest_pipeline_flyout = require("./ingest_pipeline_flyout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/enterprise_search_content/components/search_index/pipelines/ingest_pipelines/ingest_pipelines_card.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const IngestPipelinesCard = ({
  extractionDisabled
}) => {
  var _customPipeline$proce, _customPipeline$proce2;
  const {
    indexName,
    ingestionMethod
  } = (0, _kea.useValues)(_index_view_logic.IndexViewLogic);
  const {
    canSetPipeline,
    index,
    pipelineName,
    pipelineState,
    showPipelineSettings
  } = (0, _kea.useValues)(_pipelines_logic.PipelinesLogic);
  const {
    closePipelineSettings,
    openPipelineSettings,
    setPipelineState,
    savePipeline
  } = (0, _kea.useActions)(_pipelines_logic.PipelinesLogic);
  const {
    makeRequest: fetchCustomPipeline
  } = (0, _kea.useActions)(_fetch_custom_pipeline_api_logic.FetchCustomPipelineApiLogic);
  const {
    data: customPipelines
  } = (0, _kea.useValues)(_fetch_custom_pipeline_api_logic.FetchCustomPipelineApiLogic);
  const customPipeline = customPipelines ? customPipelines[`${indexName}@custom`] : undefined;
  (0, _react.useEffect)(() => {
    fetchCustomPipeline({
      indexName
    });
  }, [indexName]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 5
    }
  }, showPipelineSettings && /*#__PURE__*/_react.default.createElement(_ingest_pipeline_flyout.IngestPipelineFlyout, {
    closeFlyout: closePipelineSettings,
    displayOnly: !canSetPipeline,
    extractionDisabled: extractionDisabled,
    indexName: indexName,
    ingestionMethod: ingestionMethod,
    isLoading: false,
    pipeline: {
      ...pipelineState,
      name: pipelineName
    },
    savePipeline: savePipeline,
    setPipeline: setPipelineState,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_default_pipeline_item.DefaultPipelineItem, {
    index: index,
    openPipelineSettings: openPipelineSettings,
    pipelineName: pipelineName,
    ingestionMethod: ingestionMethod,
    indexName: indexName,
    pipelineState: pipelineState,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 11
    }
  }))), customPipeline && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "primary",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_custom_pipeline_item.CustomPipelineItem, {
    indexName: indexName,
    ingestionMethod: ingestionMethod,
    pipelineSuffix: "custom",
    processorsCount: (_customPipeline$proce = (_customPipeline$proce2 = customPipeline.processors) === null || _customPipeline$proce2 === void 0 ? void 0 : _customPipeline$proce2.length) !== null && _customPipeline$proce !== void 0 ? _customPipeline$proce : 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 13
    }
  }))));
};
exports.IngestPipelinesCard = IngestPipelinesCard;