"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAttackDiscoveryGenerationsQuery = exports.DEFAULT_START = exports.DEFAULT_END = void 0;
var _constants = require("../../../../../common/constants");
var _get_attack_discovery_generations_aggs = require("../get_attack_discovery_generations_aggs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_END = exports.DEFAULT_END = 'now';
const DEFAULT_START = exports.DEFAULT_START = 'now-24h';

/**
 * Returns an Elasticsearch query to search the event log for the authenticated
 * users' generations
 * */
const getAttackDiscoveryGenerationsQuery = ({
  authenticatedUser,
  end = DEFAULT_END,
  eventLogIndex,
  size,
  start = DEFAULT_START,
  spaceId
}) => ({
  // query metadata
  allow_no_indices: true,
  index: [eventLogIndex],
  ignore_unavailable: true,
  _source: false,
  size: 0,
  // aggregations group the generation events by their execution UUID
  aggs: {
    ...(0, _get_attack_discovery_generations_aggs.getAttackDiscoveryGenerationsAggs)(size).aggs
  },
  // query for the authenticated user's generations
  query: {
    bool: {
      must: [{
        term: {
          'event.provider': _constants.ATTACK_DISCOVERY_EVENT_PROVIDER
        }
      }, {
        term: {
          'user.name': authenticatedUser.username
        }
      }, {
        term: {
          'kibana.space_ids': spaceId
        }
      }, {
        range: {
          '@timestamp': {
            gte: start,
            lte: end,
            format: 'strict_date_optional_time'
          }
        }
      }, {
        exists: {
          field: 'kibana.alert.rule.execution.uuid'
        }
      }, {
        exists: {
          field: 'event.dataset' // connector id
        }
      }, {
        exists: {
          field: 'event.action'
        }
      }]
    }
  }
});
exports.getAttackDiscoveryGenerationsQuery = getAttackDiscoveryGenerationsQuery;