"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InterruptFactory = void 0;
var _react = _interopRequireDefault(require("react"));
var _select_option = require("./typed_interrupts/select_option");
var _input_text = require("./typed_interrupts/input_text");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/elastic_assistant/public/src/components/get_comments/typed_interrupt/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const InterruptFactory = ({
  interruptValue: interrupt,
  resumeGraph,
  interruptResumeValue: resumedValue,
  isLastInConversation
}) => {
  switch (interrupt.type) {
    case 'SELECT_OPTION':
      return /*#__PURE__*/_react.default.createElement(_select_option.SelectOption, {
        interrupt: interrupt,
        resumeGraph: resumeGraph,
        resumedValue: resumedValue,
        isLastInConversation: isLastInConversation,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 35,
          columnNumber: 9
        }
      });
    case 'INPUT_TEXT':
      return /*#__PURE__*/_react.default.createElement(_input_text.InputText, {
        interruptValue: interrupt,
        resumeGraph: resumeGraph,
        resumeValue: resumedValue,
        isLastInConversation: isLastInConversation,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 44,
          columnNumber: 9
        }
      });
    default:
      const neverValue = interrupt;
      throw new Error(`Unhandled typed interrupt type: ${JSON.stringify(neverValue)}`);
  }
};
exports.InterruptFactory = InterruptFactory;