"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLogEventTypeFieldWithFallback = void 0;
var _ = require("..");
var _get_log_field_with_fallback = require("./get_log_field_with_fallback");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// First check otel event_name field, then fallback to processor.event
// OTEL exceptions with trace processor are stored as processor.event: error
const rankingOrder = [_.fieldConstants.OTEL_EVENT_NAME_FIELD, _.fieldConstants.PROCESSOR_EVENT_FIELD];
const getLogEventTypeFieldWithFallback = doc => {
  return (0, _get_log_field_with_fallback.getLogFieldWithFallback)(doc, rankingOrder);
};
exports.getLogEventTypeFieldWithFallback = getLogEventTypeFieldWithFallback;