"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ScopedDiscoverEBTManager = exports.NON_ECS_FIELD = exports.FREE_TEXT = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _esQuery = require("@kbn/es-query");
var _esqlUtils = require("@kbn/esql-utils");
var _unifiedTabs = require("@kbn/unified-tabs");
var _discover_ebt_manager_registrations = require("./discover_ebt_manager_registrations");
var _context_awareness = require("../context_awareness");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const NON_ECS_FIELD = exports.NON_ECS_FIELD = '<non-ecs>';
const FREE_TEXT = exports.FREE_TEXT = '__FREE_TEXT__';
var FieldUsageEventName = /*#__PURE__*/function (FieldUsageEventName) {
  FieldUsageEventName["dataTableSelection"] = "dataTableSelection";
  FieldUsageEventName["dataTableRemoval"] = "dataTableRemoval";
  FieldUsageEventName["filterAddition"] = "filterAddition";
  return FieldUsageEventName;
}(FieldUsageEventName || {});
var QueryFieldsUsageEventName = /*#__PURE__*/function (QueryFieldsUsageEventName) {
  QueryFieldsUsageEventName["kqlQuery"] = "kqlQuery";
  QueryFieldsUsageEventName["esqlQuery"] = "esqlQuery";
  return QueryFieldsUsageEventName;
}(QueryFieldsUsageEventName || {});
class ScopedDiscoverEBTManager {
  constructor(reportEvent, reportPerformanceEvent, updateProfilesContextWith, setAsActiveManager) {
    (0, _defineProperty2.default)(this, "lastResolvedContextProfiles", {
      [_context_awareness.ContextualProfileLevel.rootLevel]: undefined,
      [_context_awareness.ContextualProfileLevel.dataSourceLevel]: undefined,
      [_context_awareness.ContextualProfileLevel.documentLevel]: undefined
    });
    this.reportEvent = reportEvent;
    this.reportPerformanceEvent = reportPerformanceEvent;
    this.updateProfilesContextWith = updateProfilesContextWith;
    this.setAsActiveManager = setAsActiveManager;
  }
  async getFieldsFromMetadata({
    fieldsMetadata,
    fieldNames
  }) {
    const client = await fieldsMetadata.getClient();
    const {
      fields
    } = await client.find({
      attributes: ['short'],
      fieldNames
    });
    return fields;
  }
  async trackFieldUsageEvent({
    eventName,
    fieldName,
    filterOperation,
    fieldsMetadata
  }) {
    if (!this.reportEvent) {
      return;
    }
    const eventData = {
      [_discover_ebt_manager_registrations.FIELD_USAGE_EVENT_NAME]: eventName
    };
    if (fieldsMetadata) {
      var _fields$fieldName;
      const fields = await this.getFieldsFromMetadata({
        fieldsMetadata,
        fieldNames: [fieldName]
      });

      // tracks ECS compliant fields with a field name and non-ECS compliant fields with a "<non-ecs>" label
      if ((_fields$fieldName = fields[fieldName]) !== null && _fields$fieldName !== void 0 && _fields$fieldName.short) {
        eventData[_discover_ebt_manager_registrations.FIELD_USAGE_FIELD_NAME] = fieldName;
      } else {
        eventData[_discover_ebt_manager_registrations.FIELD_USAGE_FIELD_NAME] = NON_ECS_FIELD;
      }
    }
    if (filterOperation) {
      eventData[_discover_ebt_manager_registrations.FIELD_USAGE_FILTER_OPERATION] = filterOperation;
    }
    this.reportEvent(_discover_ebt_manager_registrations.FIELD_USAGE_EVENT_TYPE, eventData);
  }
  async trackDataTableSelection({
    fieldName,
    fieldsMetadata
  }) {
    await this.trackFieldUsageEvent({
      eventName: FieldUsageEventName.dataTableSelection,
      fieldName,
      fieldsMetadata
    });
  }
  async trackDataTableRemoval({
    fieldName,
    fieldsMetadata
  }) {
    await this.trackFieldUsageEvent({
      eventName: FieldUsageEventName.dataTableRemoval,
      fieldName,
      fieldsMetadata
    });
  }
  async trackFilterAddition({
    fieldName,
    fieldsMetadata,
    filterOperation
  }) {
    await this.trackFieldUsageEvent({
      eventName: FieldUsageEventName.filterAddition,
      fieldName,
      fieldsMetadata,
      filterOperation
    });
  }
  async trackQueryFieldsUsageEvent({
    eventName,
    fieldNames,
    fieldsMetadata
  }) {
    if (!this.reportEvent) {
      return;
    }
    const eventData = {
      [_discover_ebt_manager_registrations.FIELD_USAGE_EVENT_NAME]: eventName
    };
    if (fieldsMetadata) {
      const fields = await this.getFieldsFromMetadata({
        fieldsMetadata,
        fieldNames
      });

      // tracks ECS compliant fields with a field name, non-ECS compliant fields with a "<non-ecs>" label
      // and free text searches with a "__FREE_TEXT__" label
      const categorizedFields = fieldNames.map(fieldName => {
        var _fields$fieldName2;
        return (_fields$fieldName2 = fields[fieldName]) !== null && _fields$fieldName2 !== void 0 && _fields$fieldName2.short || fieldName === FREE_TEXT ? fieldName : NON_ECS_FIELD;
      });
      eventData[_discover_ebt_manager_registrations.QUERY_FIELDS_USAGE_FIELD_NAMES] = [...new Set(categorizedFields)];
    }
    this.reportEvent(_discover_ebt_manager_registrations.QUERY_FIELDS_USAGE_EVENT_TYPE, eventData);
  }
  async trackSubmittingQuery({
    query,
    fieldsMetadata
  }) {
    if (!query) {
      return;
    }
    if ((0, _esQuery.isOfAggregateQueryType)(query)) {
      // ES|QL query

      if (query.esql.trim() === '') {
        return;
      }
      const esqlColumns = (0, _esqlUtils.getQueryColumnsFromESQLQuery)(query.esql);
      const embeddedQueries = (0, _esqlUtils.getKqlSearchQueries)(query.esql); // KQL embedded within ES|QL query

      const embeddedQueryColumns = embeddedQueries ? embeddedQueries.map(embeddedQuery => {
        const embeddedKQLFieldNames = (0, _esQuery.getKqlFieldNamesFromExpression)(embeddedQuery);
        if ((0, _esQuery.getIsKqlFreeTextExpression)(embeddedQuery)) {
          embeddedKQLFieldNames.push(FREE_TEXT);
        }
        return embeddedKQLFieldNames;
      }).flat() : [];
      const fieldNames = [...esqlColumns, ...embeddedQueryColumns];
      if (fieldNames.length === 0) {
        return;
      }
      await this.trackQueryFieldsUsageEvent({
        eventName: QueryFieldsUsageEventName.esqlQuery,
        fieldNames,
        fieldsMetadata
      });
    } else {
      // KQL query

      if (query.language !== 'kuery' ||
      // TODO for Lucene support in issue #234590
      typeof query.query !== 'string' || query.query.trim() === '') {
        return;
      }
      const fieldNames = (0, _esQuery.getKqlFieldNamesFromExpression)(query.query);
      if ((0, _esQuery.getIsKqlFreeTextExpression)(query.query)) {
        fieldNames.push(FREE_TEXT);
      }
      await this.trackQueryFieldsUsageEvent({
        eventName: QueryFieldsUsageEventName.kqlQuery,
        fieldNames,
        fieldsMetadata
      });
    }
  }
  trackContextualProfileResolvedEvent({
    contextLevel,
    profileId
  }) {
    if (!this.reportEvent) {
      return;
    }
    if (this.lastResolvedContextProfiles[contextLevel] === profileId) {
      // avoid sending duplicate events to EBT
      return;
    }
    this.lastResolvedContextProfiles[contextLevel] = profileId;
    const eventData = {
      [_discover_ebt_manager_registrations.CONTEXTUAL_PROFILE_LEVEL]: contextLevel,
      [_discover_ebt_manager_registrations.CONTEXTUAL_PROFILE_ID]: profileId
    };
    this.reportEvent(_discover_ebt_manager_registrations.CONTEXTUAL_PROFILE_RESOLVED_EVENT_TYPE, eventData);
  }
  trackPerformanceEvent(eventName) {
    const startTime = window.performance.now();
    let reported = false;
    return {
      reportEvent: eventData => {
        if (reported || !this.reportPerformanceEvent) {
          return;
        }
        reported = true;
        const duration = window.performance.now() - startTime;
        this.reportPerformanceEvent({
          ...eventData,
          eventName,
          duration
        });
      }
    };
  }
  trackTabsEvent({
    eventName,
    ...payload
  }) {
    if (!this.reportEvent) {
      return;
    }
    const eventData = {
      [_unifiedTabs.TabsEventDataKeys.TABS_EVENT_NAME]: eventName,
      ...payload
    };
    this.reportEvent(_discover_ebt_manager_registrations.TABS_EVENT_TYPE, eventData);
  }
}
exports.ScopedDiscoverEBTManager = ScopedDiscoverEBTManager;