"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ContextAppRoute = ContextAppRoute;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _context_app = require("./context_app");
var _loading_indicator = require("../../components/common/loading_indicator");
var _use_data_view = require("../../hooks/use_data_view");
var _use_discover_services = require("../../hooks/use_discover_services");
var _context_awareness = require("../../context_awareness");
var _scoped_services_provider = require("../../components/scoped_services_provider");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/discover/public/application/context/context_app_route.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ContextAppRoute() {
  const {
    profilesManager,
    ebtManager,
    getScopedHistory
  } = (0, _use_discover_services.useDiscoverServices)();
  const scopedHistory = getScopedHistory();
  const locationState = (0, _react.useMemo)(() => scopedHistory === null || scopedHistory === void 0 ? void 0 : scopedHistory.location.state, [scopedHistory === null || scopedHistory === void 0 ? void 0 : scopedHistory.location.state]);

  /**
   * Updates history state when gets undefined.
   * Should be removed once url state will be deleted from context page.
   */
  (0, _react.useEffect)(() => {
    const unlisten = scopedHistory === null || scopedHistory === void 0 ? void 0 : scopedHistory.listen(location => {
      const currentState = location.state;
      if (!(currentState !== null && currentState !== void 0 && currentState.referrer) && locationState) {
        const newLocation = {
          ...location,
          state: {
            ...currentState,
            ...locationState
          }
        };
        scopedHistory.replace(newLocation);
      }
    });
    return () => unlisten === null || unlisten === void 0 ? void 0 : unlisten();
  }, [locationState, scopedHistory]);
  const {
    dataViewId: encodedDataViewId,
    id
  } = (0, _reactRouterDom.useParams)();
  const dataViewId = decodeURIComponent(encodedDataViewId);
  const anchorId = decodeURIComponent(id);
  const {
    dataView,
    error
  } = (0, _use_data_view.useDataView)({
    index: (locationState === null || locationState === void 0 ? void 0 : locationState.dataViewSpec) || dataViewId
  });
  const [scopedEbtManager] = (0, _react.useState)(() => ebtManager.createScopedEBTManager());
  const [scopedProfilesManager] = (0, _react.useState)(() => profilesManager.createScopedProfilesManager({
    scopedEbtManager
  }));
  const rootProfileState = (0, _context_awareness.useRootProfile)();
  if (error) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "warning",
      iconColor: "danger",
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "discover.contextViewRoute.errorTitle",
        defaultMessage: "An error occurred",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 66,
          columnNumber: 11
        }
      }),
      body: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "discover.contextViewRoute.errorMessage",
        defaultMessage: "No matching data view for id {dataViewId}",
        values: {
          dataViewId
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 72,
          columnNumber: 11
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 7
      }
    });
  }
  if (!dataView || rootProfileState.rootProfileLoading) {
    return /*#__PURE__*/_react.default.createElement(_loading_indicator.LoadingIndicator, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_scoped_services_provider.ScopedServicesProvider, {
    scopedProfilesManager: scopedProfilesManager,
    scopedEBTManager: scopedEbtManager,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(rootProfileState.AppWrapper, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_context_app.ContextApp, {
    anchorId: anchorId,
    dataView: dataView,
    referrer: locationState === null || locationState === void 0 ? void 0 : locationState.referrer,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 9
    }
  })));
}