"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ContextApp = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _lodash = require("lodash");
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/data-plugin/public");
var _i18n = require("@kbn/i18n");
var _discoverUtils = require("@kbn/discover-utils");
var _unifiedDataTable = require("@kbn/unified-data-table");
var _full_body_height_css = require("@kbn/css-utils/public/full_body_height_css");
var _context_error_message = require("./components/context_error_message");
var _context_query_state = require("./services/context_query_state");
var _context_state = require("./services/context_state");
var _use_context_app_state = require("./hooks/use_context_app_state");
var _use_context_app_fetch = require("./hooks/use_context_app_fetch");
var _context_app_content = require("./context_app_content");
var _context = require("./services/context");
var _use_discover_services = require("../../hooks/use_discover_services");
var _breadcrumbs = require("../../utils/breadcrumbs");
var _scoped_services_provider = require("../../components/scoped_services_provider");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/discover/public/application/context/context_app.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ContextAppContentMemoized = /*#__PURE__*/(0, _react.memo)(_context_app_content.ContextAppContent);
const ContextApp = ({
  dataView,
  anchorId,
  referrer
}) => {
  const styles = (0, _use_memo_css.useMemoCss)(componentStyles);
  const services = (0, _use_discover_services.useDiscoverServices)();
  const {
    scopedEBTManager
  } = (0, _scoped_services_provider.useScopedServices)();
  const {
    locator,
    uiSettings,
    capabilities,
    dataViews,
    navigation,
    filterManager,
    core,
    fieldsMetadata
  } = services;

  /**
   * Context app state
   */
  const {
    appState,
    globalState,
    stateContainer
  } = (0, _use_context_app_state.useContextAppState)({
    services,
    dataView
  });
  const prevAppState = (0, _react.useRef)();
  const prevGlobalState = (0, _react.useRef)({
    filters: []
  });
  const setAppState = (0, _react.useCallback)(({
    settings,
    ...rest
  }) => {
    stateContainer.setAppState({
      ...rest,
      grid: settings
    });
  }, [stateContainer]);
  const {
    columns,
    onAddColumn,
    onRemoveColumn,
    onSetColumns
  } = (0, _unifiedDataTable.useColumns)({
    capabilities,
    defaultOrder: uiSettings.get(_discoverUtils.SORT_DEFAULT_ORDER_SETTING),
    dataView,
    dataViews,
    setAppState,
    columns: appState.columns,
    sort: appState.sort,
    settings: appState.grid
  });
  (0, _react.useEffect)(() => {
    (0, _breadcrumbs.setBreadcrumbs)({
      services,
      rootBreadcrumbPath: referrer,
      titleBreadcrumbText: _i18n.i18n.translate('discover.context.breadcrumb', {
        defaultMessage: 'Surrounding documents'
      })
    });
  }, [locator, referrer, services]);
  (0, _public.useExecutionContext)(core.executionContext, {
    type: 'application',
    page: 'context',
    id: dataView.id || ''
  });

  /**
   * Context fetched state
   */
  const {
    fetchedState,
    fetchContextRows,
    fetchAllRows,
    fetchSurroundingRows,
    resetFetchedState
  } = (0, _use_context_app_fetch.useContextAppFetch)({
    anchorId,
    dataView,
    appState
  });

  /**
   * Reset state when anchor changes
   */
  (0, _react.useEffect)(() => {
    if (prevAppState.current) {
      prevAppState.current = undefined;
      resetFetchedState();
    }
  }, [anchorId, resetFetchedState]);

  /**
   * Fetch docs on ui changes
   */
  (0, _react.useEffect)(() => {
    const doFetch = async () => {
      const surroundingDocsFetchTracker = scopedEBTManager.trackPerformanceEvent('discoverSurroundingDocsFetch');
      let fetchType = '';
      if (!prevAppState.current) {
        fetchType = 'all';
        await fetchAllRows();
      } else if (prevAppState.current.predecessorCount !== appState.predecessorCount) {
        fetchType = 'predecessors';
        await fetchSurroundingRows(_context.SurrDocType.PREDECESSORS);
      } else if (prevAppState.current.successorCount !== appState.successorCount) {
        fetchType = 'successors';
        await fetchSurroundingRows(_context.SurrDocType.SUCCESSORS);
      } else if (!(0, _context_state.isEqualFilters)(prevAppState.current.filters, appState.filters) || !(0, _context_state.isEqualFilters)(prevGlobalState.current.filters, globalState.filters)) {
        fetchType = 'context';
        await fetchContextRows();
      }
      if (fetchType) {
        surroundingDocsFetchTracker.reportEvent({
          meta: {
            fetchType
          }
        });
      }
    };
    doFetch();
    prevAppState.current = (0, _lodash.cloneDeep)(appState);
    prevGlobalState.current = (0, _lodash.cloneDeep)(globalState);
  }, [appState, globalState, anchorId, fetchContextRows, fetchAllRows, fetchSurroundingRows, fetchedState.anchor.id, scopedEBTManager]);
  const rows = (0, _react.useMemo)(() => [...(fetchedState.predecessors || []), ...(fetchedState.anchor.id ? [fetchedState.anchor] : []), ...(fetchedState.successors || [])], [fetchedState.predecessors, fetchedState.anchor, fetchedState.successors]);
  const interceptedWarnings = (0, _react.useMemo)(() => [...(fetchedState.predecessorsInterceptedWarnings || []), ...(fetchedState.anchorInterceptedWarnings || []), ...(fetchedState.successorsInterceptedWarnings || [])], [fetchedState.predecessorsInterceptedWarnings, fetchedState.anchorInterceptedWarnings, fetchedState.successorsInterceptedWarnings]);
  const addFilter = (0, _react.useCallback)(async (field, values, operation) => {
    const newFilters = (0, _public2.generateFilters)(filterManager, field, values, operation, dataView);
    filterManager.addFilters(newFilters);
    if (dataViews) {
      const fieldName = typeof field === 'string' ? field : field.name;
      await (0, _unifiedDataTable.popularizeField)(dataView, fieldName, dataViews, capabilities);
      void scopedEBTManager.trackFilterAddition({
        fieldName: fieldName === '_exists_' ? String(values) : fieldName,
        filterOperation: fieldName === '_exists_' ? '_exists_' : operation,
        fieldsMetadata
      });
    }
  }, [filterManager, dataView, dataViews, capabilities, scopedEBTManager, fieldsMetadata]);
  const onAddColumnWithTracking = (0, _react.useCallback)(columnName => {
    onAddColumn(columnName);
    void scopedEBTManager.trackDataTableSelection({
      fieldName: columnName,
      fieldsMetadata
    });
  }, [onAddColumn, scopedEBTManager, fieldsMetadata]);
  const onRemoveColumnWithTracking = (0, _react.useCallback)(columnName => {
    onRemoveColumn(columnName);
    void scopedEBTManager.trackDataTableRemoval({
      fieldName: columnName,
      fieldsMetadata
    });
  }, [onRemoveColumn, scopedEBTManager, fieldsMetadata]);
  const TopNavMenu = navigation.ui.AggregateQueryTopNavMenu;
  const getNavBarProps = () => {
    return {
      appName: 'context',
      showSearchBar: true,
      showQueryInput: false,
      showFilterBar: true,
      showDatePicker: false,
      indexPatterns: [dataView],
      useDefaultBehaviors: true
    };
  };
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 249,
      columnNumber: 5
    }
  }, fetchedState.anchorStatus.value === _context_query_state.LoadingStatus.FAILED ? /*#__PURE__*/_react.default.createElement(_context_error_message.ContextErrorMessage, {
    status: fetchedState.anchorStatus,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 253,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h1", {
    id: "contextAppTitle",
    className: "euiScreenReaderOnly",
    "data-test-subj": "discoverContextAppTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 254,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('discover.context.pageTitle', {
    defaultMessage: 'Documents surrounding #{anchorId}',
    values: {
      anchorId
    }
  })), /*#__PURE__*/_react.default.createElement(TopNavMenu, (0, _extends2.default)({}, getNavBarProps(), {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 264,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiPage, {
    css: styles.docsPage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 265,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
    panelled: true,
    paddingSize: "none",
    css: styles.docsContent,
    panelProps: {
      role: 'main'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 266,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": "contextDocumentSurroundingHeader",
    css: styles.title,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 272,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.context.contextOfTitle",
    defaultMessage: "Documents surrounding {anchorId}",
    values: {
      anchorId: /*#__PURE__*/_react.default.createElement("span", {
        css: styles.documentId,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 277,
          columnNumber: 31
        }
      }, "#", anchorId)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 273,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 281,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(ContextAppContentMemoized, {
    dataView: dataView,
    columns: columns,
    grid: appState.grid,
    onAddColumn: onAddColumnWithTracking,
    onRemoveColumn: onRemoveColumnWithTracking,
    onSetColumns: onSetColumns,
    predecessorCount: appState.predecessorCount,
    successorCount: appState.successorCount,
    setAppState: stateContainer.setAppState,
    addFilter: addFilter,
    rows: rows,
    predecessors: fetchedState.predecessors,
    successors: fetchedState.successors,
    anchorStatus: fetchedState.anchorStatus.value,
    predecessorsStatus: fetchedState.predecessorsStatus.value,
    successorsStatus: fetchedState.successorsStatus.value,
    interceptedWarnings: interceptedWarnings,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 282,
      columnNumber: 15
    }
  })))));
};
exports.ContextApp = ContextApp;
const componentStyles = {
  docsContent: (0, _react2.css)({
    display: 'flex',
    flexDirection: 'column',
    height: '100%'
  }),
  docsPage: (0, _full_body_height_css.kbnFullBodyHeightCss)('54px'),
  // 54px is the action bar height
  title: themeContext => {
    const {
      euiTheme
    } = themeContext;
    const titlePadding = (0, _eui.euiPaddingSize)(themeContext, 's');
    return (0, _react2.css)({
      padding: `${titlePadding} ${titlePadding} 0`,
      fontWeight: euiTheme.font.weight.bold
    });
  },
  documentId: ({
    euiTheme
  }) => (0, _react2.css)({
    backgroundColor: euiTheme.colors.backgroundBaseWarning,
    color: euiTheme.colors.textWarning,
    padding: `0 ${euiTheme.size.xs}`
  })
};