"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleConditionChart = RuleConditionChart;
exports.default = void 0;
var _rison = _interopRequireDefault(require("@kbn/rison"));
var _react = _interopRequireDefault(require("react"));
var _reactHooks = require("@kbn/react-hooks");
var _utils = require("../../../utils");
var _chart_preview = require("./chart_preview");
var _chart_preview_helper = require("./chart_preview/chart_preview_helper");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/dataset_quality/public/rule_types/degraded_docs/rule_form/rule_condition_chart.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function RuleConditionChart({
  threshold,
  comparator,
  timeSize,
  timeUnit,
  dataView,
  groupBy,
  timeRange,
  chartOptions: {
    interval
  } = {}
}) {
  const {
    services: {
      http,
      uiSettings
    }
  } = (0, _utils.useKibanaContextForPlugin)();
  const {
    loading,
    value,
    error
  } = (0, _reactHooks.useAbortableAsync)(async ({
    signal
  }) => {
    if (dataView && timeRange.from && timeRange.to) {
      return http.get('/internal/dataset_quality/rule_types/degraded_docs/chart_preview', {
        query: {
          index: dataView === null || dataView === void 0 ? void 0 : dataView.getIndexPattern(),
          start: timeRange === null || timeRange === void 0 ? void 0 : timeRange.from,
          end: timeRange === null || timeRange === void 0 ? void 0 : timeRange.to,
          interval: interval || `${timeSize}${timeUnit}`,
          groupBy: _rison.default.encodeArray(Array.isArray(groupBy) ? groupBy : [groupBy])
        }
      });
    }
  }, [http, dataView, groupBy, interval, timeRange === null || timeRange === void 0 ? void 0 : timeRange.from, timeRange === null || timeRange === void 0 ? void 0 : timeRange.to, timeSize, timeUnit]);
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 5
    }
  }, loading ? /*#__PURE__*/_react.default.createElement(_chart_preview_helper.LoadingState, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 9
    }
  }) : !(value !== null && value !== void 0 && value.series) || value.series.length === 0 ? /*#__PURE__*/_react.default.createElement(_chart_preview_helper.NoDataState, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 9
    }
  }) : error ? /*#__PURE__*/_react.default.createElement(_chart_preview_helper.ErrorState, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_chart_preview.ChartPreview, {
    series: value.series,
    threshold: threshold,
    uiSettings: uiSettings,
    comparator: comparator,
    yTickFormat: d => (0, _chart_preview_helper.asPercent)(d, 100),
    timeSize: timeSize,
    timeUnit: timeUnit,
    totalGroups: value.totalGroups,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 9
    }
  }));
}

// eslint-disable-next-line import/no-default-export
var _default = exports.default = RuleConditionChart;