"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFieldEditorServices = exports.useFieldEditorContext = exports.FieldEditorProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data_view_field_editor/public/components/field_editor_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const fieldEditorContext = /*#__PURE__*/(0, _react.createContext)(undefined);
const FieldEditorProvider = ({
  services,
  dataView,
  links,
  uiSettings,
  fieldTypeToProcess,
  fieldFormats,
  fieldFormatEditors,
  children,
  fieldName$,
  subfields$
}) => {
  const ctx = (0, _react.useMemo)(() => ({
    dataView,
    fieldTypeToProcess,
    links,
    uiSettings,
    services,
    fieldFormats,
    fieldFormatEditors,
    fieldName$,
    subfields$
  }), [dataView, fieldTypeToProcess, services, links, uiSettings, fieldFormats, fieldFormatEditors, fieldName$, subfields$]);
  return /*#__PURE__*/_react.default.createElement(fieldEditorContext.Provider, {
    value: ctx,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 10
    }
  }, children);
};
exports.FieldEditorProvider = FieldEditorProvider;
const useFieldEditorContext = () => {
  const ctx = (0, _react.useContext)(fieldEditorContext);
  if (ctx === undefined) {
    throw new Error('useFieldEditorContext must be used within a <FieldEditorContext />');
  }
  return ctx;
};
exports.useFieldEditorContext = useFieldEditorContext;
const useFieldEditorServices = () => useFieldEditorContext().services;
exports.useFieldEditorServices = useFieldEditorServices;