"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NodeService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _lodash = require("lodash");
var _node_config = require("./node_config");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const DEFAULT_ROLES = [..._node_config.NODE_DEFAULT_ROLES];
const containsWildcard = roles => roles.includes(_node_config.NODE_WILDCARD_CHAR);

/**
 * @internal
 */

/** @internal */
class NodeService {
  constructor(core) {
    (0, _defineProperty2.default)(this, "configService", void 0);
    (0, _defineProperty2.default)(this, "log", void 0);
    (0, _defineProperty2.default)(this, "roles", void 0);
    this.configService = core.configService;
    this.log = core.logger.get('node');
  }
  async preboot({
    loggingSystem
  }) {
    const roles = await this.getNodeRoles();
    loggingSystem.setGlobalContext({
      service: {
        node: {
          roles
        }
      }
    });
    this.log.info(`Kibana process configured with roles: [${roles.join(', ')}]`);

    // We assume the combination of node roles has been validated and avoid doing additional checks here.
    this.roles = _node_config.NODE_ALL_ROLES.reduce((acc, curr) => {
      acc[(0, _lodash.camelCase)(curr)] = roles.includes(curr);
      return acc;
    }, {});
    return {
      roles: this.roles
    };
  }
  start() {
    if (this.roles == null) {
      throw new Error('NodeService#start() can only be called after NodeService#preboot()');
    }
    return {
      roles: this.roles
    };
  }
  stop() {
    // nothing to do here yet
  }
  async getNodeRoles() {
    const {
      roles
    } = await (0, _rxjs.firstValueFrom)(this.configService.atPath(_node_config.NODE_CONFIG_PATH));
    if (containsWildcard(roles)) {
      return DEFAULT_ROLES;
    }
    return roles;
  }
}
exports.NodeService = NodeService;