"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.labelPositionSchema = exports.ignoreParentSettingsSchema = exports.controlsGroupSchema = exports.chainingSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _controlsConstants = require("@kbn/controls-constants");
var _control_schema = require("./control_schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const labelPositionSchema = exports.labelPositionSchema = _configSchema.schema.oneOf([_configSchema.schema.literal(_controlsConstants.CONTROLS_LABEL_POSITION_ONE_LINE), _configSchema.schema.literal(_controlsConstants.CONTROLS_LABEL_POSITION_TWO_LINE)], {
  defaultValue: _controlsConstants.DEFAULT_CONTROLS_LABEL_POSITION,
  meta: {
    description: 'Position of the labels for controls. For example, "oneLine", "twoLine".'
  }
});
const chainingSchema = exports.chainingSchema = _configSchema.schema.oneOf([_configSchema.schema.literal(_controlsConstants.CONTROLS_CHAINING_HIERARCHICAL), _configSchema.schema.literal(_controlsConstants.CONTROLS_CHAINING_NONE)], {
  defaultValue: _controlsConstants.DEFAULT_CONTROLS_CHAINING,
  meta: {
    description: 'The chaining strategy for multiple controls. For example, "HIERARCHICAL" or "NONE".'
  }
});
const ignoreParentSettingsSchema = exports.ignoreParentSettingsSchema = _configSchema.schema.object({
  ignoreFilters: _configSchema.schema.maybe(_configSchema.schema.boolean({
    meta: {
      description: 'Ignore global filters in controls.'
    },
    defaultValue: _controlsConstants.DEFAULT_IGNORE_PARENT_SETTINGS.ignoreFilters
  })),
  ignoreQuery: _configSchema.schema.maybe(_configSchema.schema.boolean({
    meta: {
      description: 'Ignore the global query bar in controls.'
    },
    defaultValue: _controlsConstants.DEFAULT_IGNORE_PARENT_SETTINGS.ignoreQuery
  })),
  ignoreTimerange: _configSchema.schema.maybe(_configSchema.schema.boolean({
    meta: {
      description: 'Ignore the global time range in controls.'
    },
    defaultValue: _controlsConstants.DEFAULT_IGNORE_PARENT_SETTINGS.ignoreTimerange
  })),
  ignoreValidations: _configSchema.schema.maybe(_configSchema.schema.boolean({
    meta: {
      description: 'Ignore validations in controls.'
    },
    defaultValue: _controlsConstants.DEFAULT_IGNORE_PARENT_SETTINGS.ignoreValidations
  }))
});
const controlsGroupSchema = exports.controlsGroupSchema = _configSchema.schema.object({
  controls: _configSchema.schema.arrayOf(_control_schema.controlSchema, {
    defaultValue: [],
    meta: {
      description: 'An array of control panels and their state in the control group.'
    }
  }),
  labelPosition: labelPositionSchema,
  chainingSystem: chainingSchema,
  enhancements: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any())),
  ignoreParentSettings: _configSchema.schema.maybe(ignoreParentSettingsSchema),
  autoApplySelections: _configSchema.schema.boolean({
    meta: {
      description: 'Show apply selections button in controls.'
    },
    defaultValue: _controlsConstants.DEFAULT_AUTO_APPLY_SELECTIONS
  })
}, {
  meta: {
    deprecated: true
  }
});