"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useVulnerabilityDashboardApi = void 0;
var _reactQuery = require("@kbn/react-query");
var _use_kibana = require("../hooks/use_kibana");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const cnvmKey = 'use-vulnerability-dashboard-api-key';
const useVulnerabilityDashboardApi = options => {
  const {
    http
  } = (0, _use_kibana.useKibana)().services;
  return (0, _reactQuery.useQuery)([cnvmKey], () => http.get(_constants.VULNERABILITIES_DASHBOARD_ROUTE_PATH), options);
};
exports.useVulnerabilityDashboardApi = useVulnerabilityDashboardApi;