"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CommentEditor = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _sharedUxFileContext = require("@kbn/shared-ux-file-context");
var _react = _interopRequireWildcard(require("react"));
var _pastable_editor = require("./pastable_editor");
var _editor = require("./editor");
var _utils = require("./utils");
var _use_cases_context = require("../cases_context/use_cases_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/markdown_editor/comment_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/** Shared props required by both editor variants */

/**
 * It is not guaranteed that downstream consumers of cases will have
 * defined a files context. This hook tests if the context is defined.
 */
function useHasFilesContext() {
  try {
    return !!(0, _sharedUxFileContext.useFilesContext)();
  } catch {
    return false;
  }
}
/**
 * Returns the correct editor (with or without file-paste support) based on the
 * presence of the FilesContext and a `caseId`.
 *
 * This lets higher-level forms stay unaware of the internal branching logic.
 */
const CommentEditor = exports.CommentEditor = /*#__PURE__*/(0, _react.forwardRef)((props, ref) => {
  // Consumers of Cases may not wrap their tree in <FilesContext>, so guard it.
  const hasFilesContext = useHasFilesContext();
  const {
    owner: ownerList
  } = (0, _use_cases_context.useCasesContext)();
  const owner = ownerList[0];
  if (hasFilesContext && props.caseId && (0, _utils.isOwner)(owner)) {
    return /*#__PURE__*/_react.default.createElement(_pastable_editor.PastableMarkdownEditor, (0, _extends2.default)({}, props, {
      ref: ref,
      field: props.field,
      caseId: props.caseId,
      owner: owner,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 7
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_editor.MarkdownEditor, (0, _extends2.default)({}, props, {
    ref: ref,
    onChange: props.onChange,
    value: props.value,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 10
    }
  }));
});
CommentEditor.displayName = 'CommentEditor';