"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDeleteAction = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_delete_cases = require("../../../containers/use_delete_cases");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_cases_context = require("../../cases_context/use_cases_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/actions/delete/use_delete_action.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getDeleteActionTitle = totalCases => totalCases > 1 ? i18n.BULK_ACTION_DELETE_LABEL : i18n.DELETE_ACTION_LABEL;
const useDeleteAction = ({
  onAction,
  onActionSuccess,
  isDisabled
}) => {
  const euiTheme = (0, _eui.useEuiTheme)();
  const {
    permissions
  } = (0, _use_cases_context.useCasesContext)();
  const [isModalVisible, setIsModalVisible] = (0, _react.useState)(false);
  const [caseToBeDeleted, setCaseToBeDeleted] = (0, _react.useState)([]);
  const canDelete = permissions.delete;
  const isActionDisabled = isDisabled || !canDelete;
  const onCloseModal = (0, _react.useCallback)(() => setIsModalVisible(false), []);
  const openModal = (0, _react.useCallback)(selectedCases => {
    onAction();
    setIsModalVisible(true);
    setCaseToBeDeleted(selectedCases);
  }, [onAction]);
  const {
    mutate: deleteCases
  } = (0, _use_delete_cases.useDeleteCases)();
  const onConfirmDeletion = (0, _react.useCallback)(() => {
    onCloseModal();
    deleteCases({
      caseIds: caseToBeDeleted.map(({
        id
      }) => id),
      successToasterTitle: i18n.DELETED_CASES(caseToBeDeleted.length)
    }, {
      onSuccess: onActionSuccess
    });
  }, [deleteCases, onActionSuccess, onCloseModal, caseToBeDeleted]);
  const color = isActionDisabled ? euiTheme.euiTheme.colors.disabled : 'danger';
  const getAction = selectedCases => {
    return {
      name: /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
        color: color,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 55,
          columnNumber: 13
        }
      }, getDeleteActionTitle(selectedCases.length)),
      onClick: () => openModal(selectedCases),
      disabled: isActionDisabled,
      'data-test-subj': 'cases-bulk-action-delete',
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "trash",
        size: "m",
        color: color,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 59,
          columnNumber: 13
        }
      }),
      key: 'cases-bulk-action-delete'
    };
  };
  return {
    getAction,
    isModalVisible,
    onConfirmDeletion,
    onCloseModal,
    canDelete
  };
};
exports.useDeleteAction = useDeleteAction;