"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditorMenu = void 0;
var _react = _interopRequireWildcard(require("react"));
var _editor_menu = require("./editor_menu.component");
var _use_canvas_api = require("../../hooks/use_canvas_api");
var _add_canvas_element_trigger = require("../../../state/triggers/add_canvas_element_trigger");
var _kibana_services = require("../../../services/kibana_services");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/workpad_header/editor_menu/editor_menu.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EditorMenu = () => {
  const canvasApi = (0, _use_canvas_api.useCanvasApi)();
  const [addPanelActions, setAddPanelActions] = (0, _react.useState)([]);
  (0, _react.useEffect)(() => {
    let mounted = true;
    async function loadPanelActions() {
      const registeredActions = await _kibana_services.uiActionsService.getTriggerCompatibleActions(_add_canvas_element_trigger.ADD_CANVAS_ELEMENT_TRIGGER, {
        embeddable: canvasApi
      });
      if (mounted) setAddPanelActions(registeredActions);
    }
    loadPanelActions();
    return () => {
      mounted = false;
    };
  }, [canvasApi]);
  const createNewEmbeddableFromAction = (0, _react.useCallback)((action, context, closePopover) => event => {
    closePopover();
    if (event.currentTarget instanceof HTMLAnchorElement) {
      if (!event.defaultPrevented &&
      // onClick prevented default
      event.button === 0 && (!event.currentTarget.target || event.currentTarget.target === '_self') && !(event.metaKey || event.altKey || event.ctrlKey || event.shiftKey)) {
        event.preventDefault();
        action.execute(context);
      }
    } else action.execute(context);
  }, []);
  return /*#__PURE__*/_react.default.createElement(_editor_menu.EditorMenu, {
    createNewEmbeddableFromAction: createNewEmbeddableFromAction,
    addPanelActions: addPanelActions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 5
    }
  });
};
exports.EditorMenu = EditorMenu;