"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbeddableFlyoutPortal = exports.AddEmbeddablePanel = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactDom = require("react-dom");
var _reactRedux = require("react-redux");
var _flyout = require("./flyout.component");
var _elements = require("../../state/actions/elements");
var _workpad = require("../../state/selectors/workpad");
var _embeddable = require("../../../canvas_plugin_src/expression_types/embeddable");
var _embeddable_input_to_expression = require("../../../canvas_plugin_src/renderers/embeddable/embeddable_input_to_expression");
var _kibana_services = require("../../services/kibana_services");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/embeddable_flyout/flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// @ts-expect-error untyped local
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const allowedEmbeddables = {
  [_embeddable.EmbeddableTypes.map]: id => {
    return `savedMap id="${id}" | render`;
  },
  [_embeddable.EmbeddableTypes.lens]: id => {
    return `savedLens id="${id}" | render`;
  },
  [_embeddable.EmbeddableTypes.visualization]: id => {
    return `savedVisualization id="${id}" | render`;
  }
  /*
  [EmbeddableTypes.search]: (id: string) => {
    return `filters | savedSearch id="${id}" | render`;
  },*/
};
const EmbeddableFlyoutPortal = props => {
  const el = (0, _react.useMemo)(() => document.createElement('div'), []);
  (0, _react.useEffect)(() => {
    let body = document.querySelector('body');
    if (body && el) {
      body.appendChild(el);
    }
    return () => {
      body = document.querySelector('body');
      if (body && el) {
        body.removeChild(el);
      }
    };
  }, [el]);
  if (!el) {
    return null;
  }
  return /*#__PURE__*/(0, _reactDom.createPortal)(/*#__PURE__*/_react.default.createElement(_flyout.AddEmbeddableFlyout, (0, _extends2.default)({}, props, {
    availableEmbeddables: Object.keys(allowedEmbeddables),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 5
    }
  })), el);
};
exports.EmbeddableFlyoutPortal = EmbeddableFlyoutPortal;
const AddEmbeddablePanel = ({
  availableEmbeddables,
  ...restProps
}) => {
  const isByValueEnabled = _kibana_services.presentationUtilService.labsService.isProjectEnabled('labs:canvas:byValueEmbeddable');
  const dispatch = (0, _reactRedux.useDispatch)();
  const pageId = (0, _reactRedux.useSelector)(state => (0, _workpad.getSelectedPage)(state));
  const addEmbeddable = (0, _react.useCallback)((selectedPageId, partialElement) => dispatch((0, _elements.addElement)(selectedPageId, partialElement)), [dispatch]);
  const onSelect = (0, _react.useCallback)((id, type) => {
    const partialElement = {
      expression: `markdown "Could not find embeddable for type ${type}" | render`
    };

    // If by-value is enabled, we'll handle both by-reference and by-value embeddables
    // with the new generic `embeddable` function.
    // Otherwise we fallback to the embeddable type specific expressions.
    if (isByValueEnabled) {
      partialElement.expression = (0, _embeddable_input_to_expression.embeddableInputToExpression)({
        savedObjectId: id
      }, type, undefined, true);
    } else if (allowedEmbeddables[type]) {
      partialElement.expression = allowedEmbeddables[type](id);
    }
    addEmbeddable(pageId, partialElement);
    restProps.onClose();
  }, [addEmbeddable, pageId, restProps, isByValueEnabled]);
  return /*#__PURE__*/_react.default.createElement(EmbeddableFlyoutPortal, (0, _extends2.default)({}, restProps, {
    availableEmbeddables: availableEmbeddables || [],
    onSelect: onSelect,
    isByValueEnabled: isByValueEnabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 5
    }
  }));
};
exports.AddEmbeddablePanel = AddEmbeddablePanel;