"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MLCallout = MLCallout;
exports.shouldDisplayMlCallout = shouldDisplayMlCallout;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _get_anomaly_detection_setup_state = require("../../../../common/anomaly_detection/get_anomaly_detection_setup_state");
var _use_ml_manage_jobs_href = require("../../../hooks/use_ml_manage_jobs_href");
var _apm_link_hooks = require("../links/apm/apm_link_hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/ml_callout/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function shouldDisplayMlCallout(anomalyDetectionSetupState) {
  return anomalyDetectionSetupState === _get_anomaly_detection_setup_state.AnomalyDetectionSetupState.NoJobs || anomalyDetectionSetupState === _get_anomaly_detection_setup_state.AnomalyDetectionSetupState.UpgradeableJobs || anomalyDetectionSetupState === _get_anomaly_detection_setup_state.AnomalyDetectionSetupState.LegacyJobs;
}
function MLCallout({
  onDismiss,
  onUpgradeClick,
  onCreateJobClick,
  anomalyDetectionSetupState,
  isOnSettingsPage
}) {
  const [loading, setLoading] = (0, _react.useState)(false);
  const apmGetLearnMoreHref = (0, _apm_link_hooks.useAPMHref)({
    path: '/settings/anomaly-detection'
  });
  const mlManageJobsHref = (0, _use_ml_manage_jobs_href.useMlManageJobsHref)();
  let properties;
  const getLearnMoreLink = color => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "apmGetLearnMoreLinkButton",
      color: color,
      href: apmGetLearnMoreHref,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 7
      }
    }, _i18n.i18n.translate('xpack.apm.mlCallout.learnMoreButton', {
      defaultMessage: `Learn more`
    }));
  };
  switch (anomalyDetectionSetupState) {
    case _get_anomaly_detection_setup_state.AnomalyDetectionSetupState.NoJobs:
      properties = {
        title: _i18n.i18n.translate('xpack.apm.mlCallout.noJobsCalloutTitle', {
          defaultMessage: 'Enable anomaly detection to add health status indicators to your services'
        }),
        text: _i18n.i18n.translate('xpack.apm.mlCallout.noJobsCalloutText', {
          defaultMessage: `Pinpoint anomalous transactions and see the health of upstream and downstream services with APM's anomaly detection integration. Get started in just a few minutes.`
        }),
        icon: 'info',
        color: 'primary',
        primaryAction: isOnSettingsPage ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
          "data-test-subj": "apmMLCalloutCreateMlJobButton",
          color: "primary",
          onClick: () => {
            onCreateJobClick === null || onCreateJobClick === void 0 ? void 0 : onCreateJobClick();
          },
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 78,
            columnNumber: 11
          }
        }, _i18n.i18n.translate('xpack.apm.mlCallout.noJobsCalloutButtonText', {
          defaultMessage: 'Create ML Job'
        })) : getLearnMoreLink('primary')
      };
      break;
    case _get_anomaly_detection_setup_state.AnomalyDetectionSetupState.UpgradeableJobs:
      properties = {
        title: _i18n.i18n.translate('xpack.apm.mlCallout.updateAvailableCalloutTitle', {
          defaultMessage: 'Updates available'
        }),
        text: _i18n.i18n.translate('xpack.apm.mlCallout.updateAvailableCalloutText', {
          defaultMessage: 'We have updated the anomaly detection jobs that provide insights into degraded performance and added detectors for throughput and failed transaction rate. If you choose to upgrade, we will create the new jobs and close the existing legacy jobs. The data shown in the APM app will automatically switch to the new. Please note that the option to migrate all existing jobs will not be available if you choose to create a new job.'
        }),
        color: 'success',
        icon: 'wrench',
        primaryAction: isOnSettingsPage ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
          "data-test-subj": "apmMLCalloutUpdateJobsButton",
          color: "success",
          isLoading: loading,
          onClick: () => {
            setLoading(true);
            Promise.resolve(onUpgradeClick === null || onUpgradeClick === void 0 ? void 0 : onUpgradeClick()).finally(() => {
              setLoading(false);
            });
          },
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 107,
            columnNumber: 11
          }
        }, _i18n.i18n.translate('xpack.apm.mlCallout.updateAvailableCalloutButtonText', {
          defaultMessage: 'Update jobs'
        })) : getLearnMoreLink('success')
      };
      break;
    case _get_anomaly_detection_setup_state.AnomalyDetectionSetupState.LegacyJobs:
      properties = {
        title: _i18n.i18n.translate('xpack.apm.mlCallout.legacyJobsCalloutTitle', {
          defaultMessage: 'Legacy ML jobs are no longer used in APM app'
        }),
        text: _i18n.i18n.translate('xpack.apm.mlCallout.legacyJobsCalloutText', {
          defaultMessage: 'We have discovered legacy Machine Learning jobs from our previous integration which are no longer being used in the APM app'
        }),
        icon: 'info',
        color: 'primary',
        primaryAction: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
          "data-test-subj": "apmMLCalloutReviewJobsButton",
          href: mlManageJobsHref,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 140,
            columnNumber: 11
          }
        }, _i18n.i18n.translate('xpack.apm.settings.anomaly_detection.legacy_jobs.button', {
          defaultMessage: 'Review jobs'
        }))
      };
      break;
  }
  if (!properties) {
    return null;
  }
  const dismissable = !isOnSettingsPage;
  const hasAnyActions = properties.primaryAction || dismissable;
  const actions = hasAnyActions ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    justifyContent: "spaceBetween",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 5
    }
  }, properties.primaryAction && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 9
    }
  }, properties.primaryAction)) : null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: properties.title,
    iconType: properties.icon,
    color: properties.color,
    onDismiss: dismissable ? onDismiss : undefined,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 7
    }
  }, properties.text), actions);
}