"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransactionTab = void 0;
exports.TransactionTabs = TransactionTabs;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _savedSearchComponent = require("@kbn/saved-search-component");
var _use_kibana = require("../../../../context/kibana_context/use_kibana");
var _transaction_metadata = require("../../../shared/metadata_table/transaction_metadata");
var _waterfall_container = require("./waterfall_container");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/transaction_details/waterfall_with_summary/transaction_tabs.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
let TransactionTab = exports.TransactionTab = /*#__PURE__*/function (TransactionTab) {
  TransactionTab["timeline"] = "timeline";
  TransactionTab["metadata"] = "metadata";
  TransactionTab["logs"] = "logs";
  return TransactionTab;
}({});
function TransactionTabs({
  transaction,
  waterfall,
  isLoading,
  detailTab = TransactionTab.timeline,
  waterfallItemId,
  serviceName,
  onTabClick,
  showCriticalPath,
  onShowCriticalPathChange,
  logsTableConfig,
  onLogsTableConfigChange
}) {
  const tabs = (0, _react.useMemo)(() => ({
    [TransactionTab.timeline]: {
      label: _i18n.i18n.translate('xpack.apm.propertiesTable.tabs.timelineLabel', {
        defaultMessage: 'Timeline'
      }),
      component: /*#__PURE__*/_react.default.createElement(TimelineTabContent, {
        waterfallItemId: waterfallItemId,
        serviceName: serviceName,
        waterfall: waterfall,
        showCriticalPath: showCriticalPath,
        onShowCriticalPathChange: onShowCriticalPathChange,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 59,
          columnNumber: 11
        }
      })
    },
    [TransactionTab.metadata]: {
      label: _i18n.i18n.translate('xpack.apm.propertiesTable.tabs.metadataLabel', {
        defaultMessage: 'Metadata'
      }),
      component: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, transaction && /*#__PURE__*/_react.default.createElement(MetadataTabContent, {
        transaction: transaction,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 72,
          columnNumber: 38
        }
      }))
    },
    [TransactionTab.logs]: {
      label: _i18n.i18n.translate('xpack.apm.propertiesTable.tabs.logsLabel', {
        defaultMessage: 'Logs'
      }),
      component: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, transaction && /*#__PURE__*/_react.default.createElement(LogsTabContent, {
        timestamp: transaction.timestamp.us,
        duration: transaction.transaction.duration.us,
        traceId: transaction.trace.id,
        logsTableConfig: logsTableConfig,
        onLogsTableConfigChange: onLogsTableConfigChange,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 81,
          columnNumber: 15
        }
      }))
    }
  }), [logsTableConfig, onLogsTableConfigChange, onShowCriticalPathChange, serviceName, showCriticalPath, transaction, waterfall, waterfallItemId]);
  const currentTab = tabs[detailTab];
  const TabContent = currentTab.component;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 7
    }
  }, Object.keys(TransactionTab).map(key => {
    const {
      label
    } = tabs[key];
    return /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
      onClick: () => {
        onTabClick(key);
      },
      isSelected: detailTab === key,
      key: key,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 13
      }
    }, label);
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 7
    }
  }), isLoading || !transaction ? /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 3,
    "data-test-sub": "loading-content",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, " ", TabContent));
}
function TimelineTabContent({
  waterfall,
  waterfallItemId,
  serviceName,
  showCriticalPath,
  onShowCriticalPathChange
}) {
  return /*#__PURE__*/_react.default.createElement(_waterfall_container.WaterfallContainer, {
    waterfallItemId: waterfallItemId,
    serviceName: serviceName,
    waterfall: waterfall,
    showCriticalPath: showCriticalPath,
    onShowCriticalPathChange: onShowCriticalPathChange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 5
    }
  });
}
function MetadataTabContent({
  transaction
}) {
  return /*#__PURE__*/_react.default.createElement(_transaction_metadata.TransactionMetadata, {
    transaction: transaction,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 10
    }
  });
}
function LogsTabContent({
  timestamp,
  duration,
  traceId,
  logsTableConfig,
  onLogsTableConfigChange
}) {
  const {
    services: {
      logsDataAccess: {
        services: {
          logSourcesService
        }
      },
      embeddable,
      dataViews,
      data: {
        search: {
          searchSource
        }
      }
    }
  } = (0, _use_kibana.useKibana)();
  const logSources = (0, _useAsync.default)(logSourcesService.getFlattenedLogSources);
  const startTimestamp = Math.floor(timestamp / 1000);
  const endTimestamp = Math.ceil(startTimestamp + duration / 1000);
  const framePaddingMs = 1000 * 60 * 60 * 24; // 24 hours

  const rangeFrom = new Date(startTimestamp - framePaddingMs).toISOString();
  const rangeTo = new Date(endTimestamp + framePaddingMs).toISOString();
  const timeRange = (0, _react.useMemo)(() => {
    return {
      from: rangeFrom,
      to: rangeTo
    };
  }, [rangeFrom, rangeTo]);
  const query = (0, _react.useMemo)(() => ({
    language: 'kuery',
    query: `trace.id:"${traceId}" OR (not trace.id:* AND "${traceId}")`
  }), [traceId]);
  return logSources.value ? /*#__PURE__*/_react.default.createElement(_savedSearchComponent.LazySavedSearchComponent, {
    dependencies: {
      embeddable,
      searchSource,
      dataViews
    },
    index: logSources.value,
    timeRange: timeRange,
    query: query,
    columns: logsTableConfig === null || logsTableConfig === void 0 ? void 0 : logsTableConfig.columns,
    sort: logsTableConfig === null || logsTableConfig === void 0 ? void 0 : logsTableConfig.sort,
    grid: logsTableConfig === null || logsTableConfig === void 0 ? void 0 : logsTableConfig.grid,
    rowHeight: logsTableConfig === null || logsTableConfig === void 0 ? void 0 : logsTableConfig.rowHeight,
    rowsPerPage: logsTableConfig === null || logsTableConfig === void 0 ? void 0 : logsTableConfig.rowsPerPage,
    density: logsTableConfig === null || logsTableConfig === void 0 ? void 0 : logsTableConfig.density,
    height: "60vh",
    displayOptions: {
      solutionNavIdOverride: 'oblt',
      enableDocumentViewer: true,
      enableFilters: false
    },
    onTableConfigChange: onLogsTableConfigChange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 5
    }
  }) : null;
}