"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServiceListPreview = ServiceListPreview;
var _eui = require("@elastic/eui");
var _customIcons = require("@kbn/custom-icons");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _style = require("../../../../utils/style");
var _environment_badge = require("../../../shared/environment_badge");
var _truncate_with_tooltip = require("../../../shared/truncate_with_tooltip");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/service_groups/service_group_save/service_list_preview.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DEFAULT_SORT_FIELD = 'serviceName';
const DEFAULT_SORT_DIRECTION = 'asc';
function ServiceListPreview({
  items,
  isLoading
}) {
  const [pageIndex, setPageIndex] = (0, _react.useState)(0);
  const [pageSize, setPageSize] = (0, _react.useState)(10);
  const [sortField, setSortField] = (0, _react.useState)(DEFAULT_SORT_FIELD);
  const [sortDirection, setSortDirection] = (0, _react.useState)(DEFAULT_SORT_DIRECTION);
  const onTableChange = (0, _react.useCallback)(options => {
    var _options$sort, _options$sort2;
    setPageIndex(options.page.index);
    setPageSize(options.page.size);
    setSortField(((_options$sort = options.sort) === null || _options$sort === void 0 ? void 0 : _options$sort.field) || DEFAULT_SORT_FIELD);
    setSortDirection(((_options$sort2 = options.sort) === null || _options$sort2 === void 0 ? void 0 : _options$sort2.direction) || DEFAULT_SORT_DIRECTION);
  }, []);
  const sort = (0, _react.useMemo)(() => {
    return {
      sort: {
        field: sortField,
        direction: sortDirection
      }
    };
  }, [sortField, sortDirection]);
  const pagination = (0, _react.useMemo)(() => ({
    pageIndex,
    pageSize,
    totalItemCount: items.length,
    hidePerPageOptions: true
  }), [pageIndex, pageSize, items.length]);
  const renderedItems = (0, _react.useMemo)(() => {
    const sortedItems = (0, _lodash.orderBy)(items, sortField, sortDirection);
    return sortedItems.slice(pageIndex * pageSize, (pageIndex + 1) * pageSize);
  }, [pageIndex, pageSize, sortField, sortDirection, items]);
  const columns = [{
    field: 'serviceName',
    name: _i18n.i18n.translate('xpack.apm.serviceGroups.selectServicesList.nameColumnLabel', {
      defaultMessage: 'Name'
    }),
    sortable: true,
    render: (_, {
      serviceName,
      agentName
    }) => /*#__PURE__*/_react.default.createElement(_truncate_with_tooltip.TruncateWithTooltip, {
      "data-test-subj": "apmServiceListAppLink",
      text: serviceName,
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        justifyContent: "flexStart",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 86,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 87,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_customIcons.AgentIcon, {
        agentName: agentName,
        size: "l",
        role: "presentation",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 88,
          columnNumber: 17
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 90,
          columnNumber: 15
        }
      }, serviceName)),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 9
      }
    })
  }, {
    field: 'environments',
    name: _i18n.i18n.translate('xpack.apm.serviceGroups.selectServicesList.environmentColumnLabel', {
      defaultMessage: 'Environments'
    }),
    width: `${_style.unit * 10}px`,
    sortable: true,
    render: (_, {
      environments
    }) => /*#__PURE__*/_react.default.createElement(_environment_badge.EnvironmentBadge, {
      environments: environments !== null && environments !== void 0 ? environments : [],
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 40
      }
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    loading: isLoading,
    noItemsMessage: _i18n.i18n.translate('xpack.apm.serviceGroups.selectServicesList.notFoundLabel', {
      defaultMessage: 'No services available within the last 24 hours. You can still create the group and services that match your query will be added.'
    }),
    items: renderedItems,
    columns: columns,
    sorting: sort,
    onChange: onTableChange,
    pagination: pagination,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 5
    }
  });
}