"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricItem = MetricItem;
var _react = _interopRequireDefault(require("react"));
var _charts = require("@elastic/charts");
var _chartsTheme = require("@kbn/charts-theme");
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/mobile/service_overview/stats/metric_item.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function MetricItem({
  data,
  id,
  isLoading,
  height = '124px'
}) {
  const chartBaseTheme = (0, _chartsTheme.useElasticChartsTheme)();
  const hasData = !(0, _lodash.isEmpty)(data);
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      resize: 'none',
      padding: '0px',
      overflow: 'auto',
      height,
      borderRadius: '6px'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 5
    }
  }, !hasData && isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 3,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 11
    }
  })) : /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    baseTheme: chartBaseTheme,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Metric, {
    id: `metric_${id}`,
    data: [data],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 11
    }
  })));
}