"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createTaskRunnerLogger = createTaskRunnerLogger;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createTaskRunnerLogger(opts) {
  return new TaskRunnerLogger(opts);
}
class TaskRunnerLogger {
  constructor(opts) {
    (0, _defineProperty2.default)(this, "loggerMetaTags", []);
    this.opts = opts;
    this.loggerMetaTags = opts.tags;
  }
  trace(message, meta) {
    this.opts.logger.trace(message, {
      ...meta,
      tags: this.combineTags(meta === null || meta === void 0 ? void 0 : meta.tags)
    });
  }
  debug(message, meta) {
    this.opts.logger.debug(message, {
      ...meta,
      tags: this.combineTags(meta === null || meta === void 0 ? void 0 : meta.tags)
    });
  }
  info(message, meta) {
    this.opts.logger.info(message, {
      ...meta,
      tags: this.combineTags(meta === null || meta === void 0 ? void 0 : meta.tags)
    });
  }
  warn(errorOrMessage, meta) {
    this.opts.logger.warn(errorOrMessage, {
      ...meta,
      tags: this.combineTags(meta === null || meta === void 0 ? void 0 : meta.tags)
    });
  }
  error(errorOrMessage, meta) {
    this.opts.logger.error(errorOrMessage, {
      ...meta,
      tags: this.combineTags(meta === null || meta === void 0 ? void 0 : meta.tags)
    });
  }
  fatal(errorOrMessage, meta) {
    this.opts.logger.fatal(errorOrMessage, {
      ...meta,
      tags: this.combineTags(meta === null || meta === void 0 ? void 0 : meta.tags)
    });
  }
  log(record) {
    this.opts.logger.log(record);
  }
  isLevelEnabled(level) {
    return this.opts.logger.isLevelEnabled(level);
  }
  get(...childContextPaths) {
    return this.opts.logger.get(...childContextPaths);
  }
  combineTags(tags) {
    if (!tags) {
      return this.loggerMetaTags;
    }
    if (typeof tags === 'string') {
      return [...new Set([...this.loggerMetaTags, tags])];
    }
    return [...new Set([...this.loggerMetaTags, ...tags])];
  }
}